/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.shaded.client.io.grpc.ForwardingServerCallListener;
import alluxio.shaded.client.io.grpc.Grpc;
import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.ServerCall;
import alluxio.shaded.client.io.grpc.ServerCallHandler;
import alluxio.shaded.client.io.grpc.ServerInterceptor;

public class ClientIpAddressInjector
implements ServerInterceptor {
    private static ThreadLocal<String> sIpAddressThreadLocal = new ThreadLocal();

    public static String getIpAddress() {
        return sIpAddressThreadLocal.get();
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

            @Override
            public void onHalfClose() {
                String remoteIpAddress = call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR).toString();
                sIpAddressThreadLocal.set(remoteIpAddress);
                super.onHalfClose();
            }
        };
    }
}

