/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.exception.status.UnavailableException;
import alluxio.exception.status.UnknownException;
import alluxio.grpc.SaslMessage;
import alluxio.security.authentication.SaslHandshakeClientHandler;
import alluxio.shaded.client.com.google.common.util.concurrent.SettableFuture;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import alluxio.util.LogUtils;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslStreamClientDriver
implements StreamObserver<SaslMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(SaslStreamClientDriver.class);
    private StreamObserver<SaslMessage> mRequestObserver;
    private SaslHandshakeClientHandler mSaslHandshakeClientHandler;
    private SettableFuture<Boolean> mHandshakeFuture;
    private AtomicBoolean mAuthenticated;
    private UUID mChannelId;
    private final long mGrpcAuthTimeoutMs;

    public SaslStreamClientDriver(SaslHandshakeClientHandler handshakeClient, AtomicBoolean authenticated, UUID channelId, long grpcAuthTimeoutMs) {
        this.mSaslHandshakeClientHandler = handshakeClient;
        this.mHandshakeFuture = SettableFuture.create();
        this.mChannelId = channelId;
        this.mGrpcAuthTimeoutMs = grpcAuthTimeoutMs;
        this.mAuthenticated = authenticated;
    }

    public void setServerObserver(StreamObserver<SaslMessage> requestObserver) {
        this.mRequestObserver = requestObserver;
    }

    @Override
    public void onNext(SaslMessage saslMessage) {
        try {
            LOG.debug("SaslClientDriver received message: {} for channel: {}", (Object)saslMessage, (Object)this.mChannelId);
            SaslMessage response = this.mSaslHandshakeClientHandler.handleSaslMessage(saslMessage);
            if (response != null) {
                this.mRequestObserver.onNext(response);
            } else {
                this.mHandshakeFuture.set(true);
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while handling SASL message: {} for channel: {}. Error: {}", new Object[]{saslMessage, this.mChannelId, e});
            this.mHandshakeFuture.setException(e);
            this.mRequestObserver.onError(e);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.mHandshakeFuture.setException(throwable);
        String errorMsg = String.format("Received error on client driver for channel: %s. Error: %s", this.mChannelId, throwable);
        if (throwable instanceof StatusRuntimeException && ((StatusRuntimeException)throwable).getStatus().getCode() == Status.Code.UNAVAILABLE) {
            LOG.debug(errorMsg);
        } else {
            LOG.warn(errorMsg);
        }
    }

    @Override
    public void onCompleted() {
        LOG.debug("Client authentication closed by server for channel: {}", (Object)this.mChannelId);
        this.mAuthenticated.set(false);
    }

    public void start() throws AlluxioStatusException {
        try {
            LOG.debug("Starting SASL handshake for channel: {}", (Object)this.mChannelId);
            this.mRequestObserver.onNext(this.mSaslHandshakeClientHandler.getInitialMessage(this.mChannelId));
            this.mAuthenticated.set((Boolean)this.mHandshakeFuture.get(this.mGrpcAuthTimeoutMs, TimeUnit.MILLISECONDS));
        }
        catch (SaslException se) {
            throw new UnauthenticatedException(se.getMessage(), se);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new UnavailableException(ie.getMessage(), ie);
        }
        catch (ExecutionException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause != null && cause instanceof StatusRuntimeException) {
                StatusRuntimeException sre = (StatusRuntimeException)cause;
                if (sre.getStatus().getCode() == Status.Code.UNIMPLEMENTED) {
                    throw new UnauthenticatedException("Authentication is disabled on target host.");
                }
                throw AlluxioStatusException.fromStatusRuntimeException((StatusRuntimeException)cause);
            }
            throw new UnknownException(cause.getMessage(), cause);
        }
        catch (TimeoutException e) {
            throw new UnavailableException(e);
        }
    }

    public void stop() {
        LOG.debug("Closing client driver for channel: {}", (Object)this.mChannelId);
        try {
            if (this.mAuthenticated.get()) {
                this.mRequestObserver.onCompleted();
            }
        }
        catch (Exception exc) {
            LogUtils.warnWithException(LOG, "Failed stopping authentication session with server.", exc);
        }
    }
}

