/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication.plain;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedUserInfo;
import alluxio.security.authentication.AuthenticationProvider;
import alluxio.security.authentication.SaslServerHandler;
import alluxio.security.authentication.plain.PlainSaslServerCallbackHandler;
import alluxio.security.authentication.plain.PlainSaslServerProvider;
import java.security.Security;
import java.util.HashMap;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslServerHandlerPlain
implements SaslServerHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SaslServerHandlerPlain.class);
    private final SaslServer mSaslServer;

    public SaslServerHandlerPlain(String serverName, AlluxioConfiguration conf) throws SaslException {
        AuthType authType = conf.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
        AuthenticationProvider provider = AuthenticationProvider.Factory.create(authType, conf);
        this.mSaslServer = Sasl.createSaslServer("PLAIN", null, serverName, new HashMap(), new PlainSaslServerCallbackHandler(provider, conf));
    }

    @Override
    public void setAuthenticatedUserInfo(AuthenticatedUserInfo userinfo) {
    }

    @Override
    public AuthenticatedUserInfo getAuthenticatedUserInfo() {
        return new AuthenticatedUserInfo(this.mSaslServer.getAuthorizationID());
    }

    @Override
    public SaslServer getSaslServer() {
        return this.mSaslServer;
    }

    @Override
    public void close() {
        if (this.mSaslServer != null) {
            try {
                this.mSaslServer.dispose();
            }
            catch (SaslException exc) {
                LOG.debug("Failed to close SaslClient.", (Throwable)exc);
            }
        }
    }

    static {
        Security.addProvider(new PlainSaslServerProvider());
    }
}

