/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.login;

import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.OSUtils;

@ThreadSafe
public final class LoginModuleConfigurationUtils {
    public static final String OS_LOGIN_MODULE_NAME = LoginModuleConfigurationUtils.getOSLoginModuleName();
    public static final String OS_PRINCIPAL_CLASS_NAME = LoginModuleConfigurationUtils.getOSPrincipalClassName();

    private LoginModuleConfigurationUtils() {
    }

    private static String getOSLoginModuleName() {
        if (OSUtils.IBM_JAVA) {
            if (OSUtils.isWindows()) {
                return OSUtils.is64Bit() ? "alluxio.shaded.client.com.ibm.security.auth.module.Win64LoginModule" : "alluxio.shaded.client.com.ibm.security.auth.module.NTLoginModule";
            }
            if (OSUtils.isAIX()) {
                return OSUtils.is64Bit() ? "alluxio.shaded.client.com.ibm.security.auth.module.AIX64LoginModule" : "alluxio.shaded.client.com.ibm.security.auth.module.AIXLoginModule";
            }
            return "alluxio.shaded.client.com.ibm.security.auth.module.LinuxLoginModule";
        }
        return OSUtils.isWindows() ? "com.sun.security.auth.module.NTLoginModule" : "com.sun.security.auth.module.UnixLoginModule";
    }

    private static String getOSPrincipalClassName() {
        String principalClassName = OSUtils.IBM_JAVA ? (OSUtils.is64Bit() ? "alluxio.shaded.client.com.ibm.security.auth.UsernamePrincipal" : (OSUtils.isWindows() ? "alluxio.shaded.client.com.ibm.security.auth.NTUserPrincipal" : (OSUtils.isAIX() ? "alluxio.shaded.client.com.ibm.security.auth.AIXPrincipal" : "alluxio.shaded.client.com.ibm.security.auth.LinuxPrincipal"))) : (OSUtils.isWindows() ? "com.sun.security.auth.NTUserPrincipal" : "com.sun.security.auth.UnixPrincipal");
        return principalClassName;
    }
}

