/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.curator.framework.recipes.cache;

import alluxio.shaded.client.com.google.common.base.Function;
import alluxio.shaded.client.org.apache.curator.framework.CuratorFramework;
import alluxio.shaded.client.org.apache.curator.framework.WatcherRemoveCuratorFramework;
import alluxio.shaded.client.org.apache.curator.framework.api.BackgroundCallback;
import alluxio.shaded.client.org.apache.curator.framework.api.BackgroundPathable;
import alluxio.shaded.client.org.apache.curator.framework.api.CuratorEvent;
import alluxio.shaded.client.org.apache.curator.framework.api.ErrorListenerPathable;
import alluxio.shaded.client.org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import alluxio.shaded.client.org.apache.curator.framework.api.WatchPathable;
import alluxio.shaded.client.org.apache.curator.framework.listen.ListenerContainer;
import alluxio.shaded.client.org.apache.curator.framework.recipes.cache.ChildData;
import alluxio.shaded.client.org.apache.curator.framework.recipes.cache.NodeCacheListener;
import alluxio.shaded.client.org.apache.curator.framework.state.ConnectionState;
import alluxio.shaded.client.org.apache.curator.framework.state.ConnectionStateListener;
import alluxio.shaded.client.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.org.apache.curator.shaded.com.google.common.base.Objects;
import alluxio.shaded.client.org.apache.curator.shaded.com.google.common.base.Preconditions;
import alluxio.shaded.client.org.apache.curator.utils.PathUtils;
import alluxio.shaded.client.org.apache.curator.utils.ThreadUtils;
import alluxio.shaded.client.org.apache.zookeeper.KeeperException;
import alluxio.shaded.client.org.apache.zookeeper.WatchedEvent;
import alluxio.shaded.client.org.apache.zookeeper.Watcher;
import alluxio.shaded.client.org.apache.zookeeper.data.Stat;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Exchanger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeCache
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WatcherRemoveCuratorFramework client;
    private final String path;
    private final boolean dataIsCompressed;
    private final AtomicReference<ChildData> data = new AtomicReference<Object>(null);
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final ListenerContainer<NodeCacheListener> listeners = new ListenerContainer();
    private final AtomicBoolean isConnected = new AtomicBoolean(true);
    private ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.CONNECTED || newState == ConnectionState.RECONNECTED) {
                if (NodeCache.this.isConnected.compareAndSet(false, true)) {
                    try {
                        NodeCache.this.reset();
                    }
                    catch (Exception e) {
                        ThreadUtils.checkInterrupted(e);
                        NodeCache.this.log.error("Trying to reset after reconnection", (Throwable)e);
                    }
                }
            } else {
                NodeCache.this.isConnected.set(false);
            }
        }
    };
    private Watcher watcher = new Watcher(){

        @Override
        public void process(WatchedEvent event) {
            try {
                NodeCache.this.reset();
            }
            catch (Exception e) {
                ThreadUtils.checkInterrupted(e);
                NodeCache.this.handleException(e);
            }
        }
    };
    private final BackgroundCallback backgroundCallback = new BackgroundCallback(){

        @Override
        public void processResult(CuratorFramework client, CuratorEvent event) throws Exception {
            NodeCache.this.processBackgroundResult(event);
        }
    };
    @VisibleForTesting
    volatile Exchanger<Object> rebuildTestExchanger;

    public NodeCache(CuratorFramework client, String path) {
        this(client, path, false);
    }

    public NodeCache(CuratorFramework client, String path, boolean dataIsCompressed) {
        this.client = client.newWatcherRemoveCuratorFramework();
        this.path = PathUtils.validatePath(path);
        this.dataIsCompressed = dataIsCompressed;
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public void start() throws Exception {
        this.start(false);
    }

    public void start(boolean buildInitial) throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        this.client.getConnectionStateListenable().addListener(this.connectionStateListener);
        if (buildInitial) {
            this.client.checkExists().creatingParentContainersIfNeeded().forPath(this.path);
            this.internalRebuild();
        }
        this.reset();
    }

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.client.removeWatchers();
            this.listeners.clear();
            this.client.getConnectionStateListenable().removeListener(this.connectionStateListener);
            this.connectionStateListener = null;
            this.watcher = null;
        }
    }

    public ListenerContainer<NodeCacheListener> getListenable() {
        Preconditions.checkState(this.state.get() != State.CLOSED, "Closed");
        return this.listeners;
    }

    public void rebuild() throws Exception {
        Preconditions.checkState(this.state.get() == State.STARTED, "Not started");
        this.internalRebuild();
        this.reset();
    }

    public ChildData getCurrentData() {
        return this.data.get();
    }

    public String getPath() {
        return this.path;
    }

    private void reset() throws Exception {
        if (this.state.get() == State.STARTED && this.isConnected.get()) {
            ((ErrorListenerPathable)((BackgroundPathable)this.client.checkExists().creatingParentContainersIfNeeded().usingWatcher(this.watcher)).inBackground(this.backgroundCallback)).forPath(this.path);
        }
    }

    private void internalRebuild() throws Exception {
        try {
            Stat stat = new Stat();
            byte[] bytes = this.dataIsCompressed ? (byte[])((WatchPathable)((GetDataWatchBackgroundStatable)this.client.getData().decompressed()).storingStatIn(stat)).forPath(this.path) : (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(this.path);
            this.data.set(new ChildData(this.path, stat, bytes));
        }
        catch (KeeperException.NoNodeException e) {
            this.data.set(null);
        }
    }

    private void processBackgroundResult(CuratorEvent event) throws Exception {
        switch (event.getType()) {
            case GET_DATA: {
                if (event.getResultCode() != KeeperException.Code.OK.intValue()) break;
                ChildData childData = new ChildData(this.path, event.getStat(), event.getData());
                this.setNewData(childData);
                break;
            }
            case EXISTS: {
                if (event.getResultCode() == KeeperException.Code.NONODE.intValue()) {
                    this.setNewData(null);
                    break;
                }
                if (event.getResultCode() != KeeperException.Code.OK.intValue()) break;
                if (this.dataIsCompressed) {
                    ((ErrorListenerPathable)((BackgroundPathable)((GetDataWatchBackgroundStatable)this.client.getData().decompressed()).usingWatcher(this.watcher)).inBackground(this.backgroundCallback)).forPath(this.path);
                    break;
                }
                ((ErrorListenerPathable)((BackgroundPathable)this.client.getData().usingWatcher(this.watcher)).inBackground(this.backgroundCallback)).forPath(this.path);
            }
        }
    }

    private void setNewData(ChildData newData) throws InterruptedException {
        ChildData previousData = this.data.getAndSet(newData);
        if (!Objects.equal(previousData, newData)) {
            this.listeners.forEach(new Function<NodeCacheListener, Void>(){

                @Override
                public Void apply(NodeCacheListener listener) {
                    try {
                        listener.nodeChanged();
                    }
                    catch (Exception e) {
                        ThreadUtils.checkInterrupted(e);
                        NodeCache.this.log.error("Calling listener", (Throwable)e);
                    }
                    return null;
                }
            });
            if (this.rebuildTestExchanger != null) {
                try {
                    this.rebuildTestExchanger.exchange(new Object());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected void handleException(Throwable e) {
        this.log.error("", e);
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

