/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.jboss.netty.channel;

import alluxio.shaded.client.org.jboss.netty.channel.ChannelEvent;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelFuture;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelPipeline;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelPipelineException;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelSink;
import alluxio.shaded.client.org.jboss.netty.channel.Channels;

public abstract class AbstractChannelSink
implements ChannelSink {
    protected AbstractChannelSink() {
    }

    public void exceptionCaught(ChannelPipeline pipeline, ChannelEvent event, ChannelPipelineException cause) throws Exception {
        Throwable actualCause = cause.getCause();
        if (actualCause == null) {
            actualCause = cause;
        }
        if (this.isFireExceptionCaughtLater(event, actualCause)) {
            Channels.fireExceptionCaughtLater(event.getChannel(), actualCause);
        } else {
            Channels.fireExceptionCaught(event.getChannel(), actualCause);
        }
    }

    protected boolean isFireExceptionCaughtLater(ChannelEvent event, Throwable actualCause) {
        return false;
    }

    public ChannelFuture execute(ChannelPipeline pipeline, Runnable task) {
        try {
            task.run();
            return Channels.succeededFuture(pipeline.getChannel());
        }
        catch (Throwable t) {
            return Channels.failedFuture(pipeline.getChannel(), t);
        }
    }
}

