/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.jboss.netty.channel;

import alluxio.shaded.client.org.jboss.netty.channel.Channel;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelDownstreamHandler;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelEvent;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelFuture;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelHandler;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelHandlerLifeCycleException;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelPipeline;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelPipelineException;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelSink;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelUpstreamHandler;
import alluxio.shaded.client.org.jboss.netty.channel.DefaultChannelPipeline;
import alluxio.shaded.client.org.jboss.netty.channel.ExceptionEvent;
import alluxio.shaded.client.org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import alluxio.shaded.client.org.jboss.netty.channel.UpstreamMessageEvent;
import alluxio.shaded.client.org.jboss.netty.logging.InternalLogger;
import alluxio.shaded.client.org.jboss.netty.logging.InternalLoggerFactory;
import alluxio.shaded.client.org.jboss.netty.util.internal.ConversionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class StaticChannelPipeline
implements ChannelPipeline {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(StaticChannelPipeline.class);
    private volatile Channel channel;
    private volatile ChannelSink sink;
    private final StaticChannelHandlerContext[] contexts;
    private final int lastIndex;
    private final Map<String, StaticChannelHandlerContext> name2ctx = new HashMap<String, StaticChannelHandlerContext>(4);

    public StaticChannelPipeline(ChannelHandler ... handlers) {
        ChannelHandler h2;
        int nContexts;
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        if (handlers.length == 0) {
            throw new IllegalArgumentException("no handlers specified");
        }
        StaticChannelHandlerContext[] contexts = new StaticChannelHandlerContext[handlers.length];
        for (nContexts = 0; nContexts < contexts.length && (h2 = handlers[nContexts]) != null; ++nContexts) {
        }
        if (nContexts == contexts.length) {
            this.contexts = contexts;
            this.lastIndex = contexts.length - 1;
        } else {
            contexts = new StaticChannelHandlerContext[nContexts];
            this.contexts = contexts;
            this.lastIndex = nContexts - 1;
        }
        for (int i = 0; i < nContexts; ++i) {
            StaticChannelHandlerContext ctx;
            ChannelHandler h3 = handlers[i];
            String name = ConversionUtil.toString(i);
            contexts[i] = ctx = new StaticChannelHandlerContext(i, name, h3);
            this.name2ctx.put(name, ctx);
        }
        for (StaticChannelHandlerContext ctx : contexts) {
            StaticChannelPipeline.callBeforeAdd(ctx);
            StaticChannelPipeline.callAfterAdd(ctx);
        }
    }

    @Override
    public ChannelFuture execute(Runnable task) {
        return this.getSink().execute(this, task);
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public ChannelSink getSink() {
        ChannelSink sink = this.sink;
        if (sink == null) {
            return DefaultChannelPipeline.discardingSink;
        }
        return sink;
    }

    @Override
    public void attach(Channel channel, ChannelSink sink) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (sink == null) {
            throw new NullPointerException("sink");
        }
        if (this.channel != null || this.sink != null) {
            throw new IllegalStateException("attached already");
        }
        this.channel = channel;
        this.sink = sink;
    }

    @Override
    public boolean isAttached() {
        return this.sink != null;
    }

    @Override
    public void addFirst(String name, ChannelHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLast(String name, ChannelHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBefore(String baseName, String name, ChannelHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAfter(String baseName, String name, ChannelHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ChannelHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelHandler remove(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends ChannelHandler> T remove(Class<T> handlerType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelHandler removeFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelHandler removeLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replace(ChannelHandler oldHandler, String newName, ChannelHandler newHandler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelHandler replace(String oldName, String newName, ChannelHandler newHandler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends ChannelHandler> T replace(Class<T> oldHandlerType, String newName, ChannelHandler newHandler) {
        throw new UnsupportedOperationException();
    }

    private static void callBeforeAdd(ChannelHandlerContext ctx) {
        if (!(ctx.getHandler() instanceof LifeCycleAwareChannelHandler)) {
            return;
        }
        LifeCycleAwareChannelHandler h2 = (LifeCycleAwareChannelHandler)ctx.getHandler();
        try {
            h2.beforeAdd(ctx);
        }
        catch (Throwable t) {
            throw new ChannelHandlerLifeCycleException(h2.getClass().getName() + ".beforeAdd() has thrown an exception; not adding.", t);
        }
    }

    private static void callAfterAdd(ChannelHandlerContext ctx) {
        if (!(ctx.getHandler() instanceof LifeCycleAwareChannelHandler)) {
            return;
        }
        LifeCycleAwareChannelHandler h2 = (LifeCycleAwareChannelHandler)ctx.getHandler();
        try {
            h2.afterAdd(ctx);
        }
        catch (Throwable t) {
            boolean removed = false;
            try {
                StaticChannelPipeline.callBeforeRemove(ctx);
                StaticChannelPipeline.callAfterRemove(ctx);
                removed = true;
            }
            catch (Throwable t2) {
                logger.warn("Failed to remove a handler: " + ctx.getName(), t2);
            }
            if (removed) {
                throw new ChannelHandlerLifeCycleException(h2.getClass().getName() + ".afterAdd() has thrown an exception; removed.", t);
            }
            throw new ChannelHandlerLifeCycleException(h2.getClass().getName() + ".afterAdd() has thrown an exception; also failed to remove.", t);
        }
    }

    private static void callBeforeRemove(ChannelHandlerContext ctx) {
        if (!(ctx.getHandler() instanceof LifeCycleAwareChannelHandler)) {
            return;
        }
        LifeCycleAwareChannelHandler h2 = (LifeCycleAwareChannelHandler)ctx.getHandler();
        try {
            h2.beforeRemove(ctx);
        }
        catch (Throwable t) {
            throw new ChannelHandlerLifeCycleException(h2.getClass().getName() + ".beforeRemove() has thrown an exception; not removing.", t);
        }
    }

    private static void callAfterRemove(ChannelHandlerContext ctx) {
        if (!(ctx.getHandler() instanceof LifeCycleAwareChannelHandler)) {
            return;
        }
        LifeCycleAwareChannelHandler h2 = (LifeCycleAwareChannelHandler)ctx.getHandler();
        try {
            h2.afterRemove(ctx);
        }
        catch (Throwable t) {
            throw new ChannelHandlerLifeCycleException(h2.getClass().getName() + ".afterRemove() has thrown an exception.", t);
        }
    }

    @Override
    public ChannelHandler getFirst() {
        return this.contexts[0].getHandler();
    }

    @Override
    public ChannelHandler getLast() {
        return this.contexts[this.contexts.length - 1].getHandler();
    }

    @Override
    public ChannelHandler get(String name) {
        StaticChannelHandlerContext ctx = this.name2ctx.get(name);
        if (ctx == null) {
            return null;
        }
        return ctx.getHandler();
    }

    @Override
    public <T extends ChannelHandler> T get(Class<T> handlerType) {
        ChannelHandlerContext ctx = this.getContext(handlerType);
        if (ctx == null) {
            return null;
        }
        ChannelHandler handler = ctx.getHandler();
        return (T)handler;
    }

    @Override
    public ChannelHandlerContext getContext(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.name2ctx.get(name);
    }

    @Override
    public ChannelHandlerContext getContext(ChannelHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        for (StaticChannelHandlerContext ctx : this.contexts) {
            if (ctx.getHandler() != handler) continue;
            return ctx;
        }
        return null;
    }

    @Override
    public ChannelHandlerContext getContext(Class<? extends ChannelHandler> handlerType) {
        if (handlerType == null) {
            throw new NullPointerException("handlerType");
        }
        for (StaticChannelHandlerContext ctx : this.contexts) {
            if (!handlerType.isAssignableFrom(ctx.getHandler().getClass())) continue;
            return ctx;
        }
        return null;
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (StaticChannelHandlerContext ctx : this.contexts) {
            list.add(ctx.getName());
        }
        return list;
    }

    @Override
    public Map<String, ChannelHandler> toMap() {
        LinkedHashMap<String, ChannelHandler> map = new LinkedHashMap<String, ChannelHandler>();
        for (StaticChannelHandlerContext ctx : this.contexts) {
            map.put(ctx.getName(), ctx.getHandler());
        }
        return map;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append('{');
        for (StaticChannelHandlerContext ctx : this.contexts) {
            buf.append('(');
            buf.append(ctx.getName());
            buf.append(" = ");
            buf.append(ctx.getHandler().getClass().getName());
            buf.append(')');
            buf.append(", ");
        }
        buf.replace(buf.length() - 2, buf.length(), "}");
        return buf.toString();
    }

    @Override
    public void sendUpstream(ChannelEvent e) {
        StaticChannelHandlerContext head = this.getActualUpstreamContext(0);
        if (head == null) {
            logger.warn("The pipeline contains no upstream handlers; discarding: " + e);
            return;
        }
        this.sendUpstream(head, e);
    }

    void sendUpstream(StaticChannelHandlerContext ctx, ChannelEvent e) {
        try {
            ((ChannelUpstreamHandler)ctx.getHandler()).handleUpstream(ctx, e);
        }
        catch (Throwable t) {
            this.notifyHandlerException(e, t);
        }
    }

    @Override
    public void sendDownstream(ChannelEvent e) {
        StaticChannelHandlerContext tail = this.getActualDownstreamContext(this.lastIndex);
        if (tail == null) {
            try {
                this.getSink().eventSunk(this, e);
                return;
            }
            catch (Throwable t) {
                this.notifyHandlerException(e, t);
                return;
            }
        }
        this.sendDownstream(tail, e);
    }

    void sendDownstream(StaticChannelHandlerContext ctx, ChannelEvent e) {
        if (e instanceof UpstreamMessageEvent) {
            throw new IllegalArgumentException("cannot send an upstream event to downstream");
        }
        try {
            ((ChannelDownstreamHandler)ctx.getHandler()).handleDownstream(ctx, e);
        }
        catch (Throwable t) {
            e.getFuture().setFailure(t);
            this.notifyHandlerException(e, t);
        }
    }

    private StaticChannelHandlerContext getActualUpstreamContext(int index) {
        for (int i = index; i < this.contexts.length; ++i) {
            StaticChannelHandlerContext ctx = this.contexts[i];
            if (!ctx.canHandleUpstream()) continue;
            return ctx;
        }
        return null;
    }

    private StaticChannelHandlerContext getActualDownstreamContext(int index) {
        for (int i = index; i >= 0; --i) {
            StaticChannelHandlerContext ctx = this.contexts[i];
            if (!ctx.canHandleDownstream()) continue;
            return ctx;
        }
        return null;
    }

    protected void notifyHandlerException(ChannelEvent e, Throwable t) {
        if (e instanceof ExceptionEvent) {
            logger.warn("An exception was thrown by a user handler while handling an exception event (" + e + ')', t);
            return;
        }
        ChannelPipelineException pe = t instanceof ChannelPipelineException ? (ChannelPipelineException)t : new ChannelPipelineException(t);
        try {
            this.sink.exceptionCaught(this, e, pe);
        }
        catch (Exception e1) {
            logger.warn("An exception was thrown by an exception handler.", e1);
        }
    }

    private final class StaticChannelHandlerContext
    implements ChannelHandlerContext {
        private final int index;
        private final String name;
        private final ChannelHandler handler;
        private final boolean canHandleUpstream;
        private final boolean canHandleDownstream;
        private volatile Object attachment;

        StaticChannelHandlerContext(int index, String name, ChannelHandler handler) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (handler == null) {
                throw new NullPointerException("handler");
            }
            this.canHandleUpstream = handler instanceof ChannelUpstreamHandler;
            this.canHandleDownstream = handler instanceof ChannelDownstreamHandler;
            if (!this.canHandleUpstream && !this.canHandleDownstream) {
                throw new IllegalArgumentException("handler must be either " + ChannelUpstreamHandler.class.getName() + " or " + ChannelDownstreamHandler.class.getName() + '.');
            }
            this.index = index;
            this.name = name;
            this.handler = handler;
        }

        public Channel getChannel() {
            return this.getPipeline().getChannel();
        }

        public ChannelPipeline getPipeline() {
            return StaticChannelPipeline.this;
        }

        public boolean canHandleDownstream() {
            return this.canHandleDownstream;
        }

        public boolean canHandleUpstream() {
            return this.canHandleUpstream;
        }

        public ChannelHandler getHandler() {
            return this.handler;
        }

        public String getName() {
            return this.name;
        }

        public Object getAttachment() {
            return this.attachment;
        }

        public void setAttachment(Object attachment) {
            this.attachment = attachment;
        }

        public void sendDownstream(ChannelEvent e) {
            StaticChannelHandlerContext prev = StaticChannelPipeline.this.getActualDownstreamContext(this.index - 1);
            if (prev == null) {
                try {
                    StaticChannelPipeline.this.getSink().eventSunk(StaticChannelPipeline.this, e);
                }
                catch (Throwable t) {
                    StaticChannelPipeline.this.notifyHandlerException(e, t);
                }
            } else {
                StaticChannelPipeline.this.sendDownstream(prev, e);
            }
        }

        public void sendUpstream(ChannelEvent e) {
            StaticChannelHandlerContext next = StaticChannelPipeline.this.getActualUpstreamContext(this.index + 1);
            if (next != null) {
                StaticChannelPipeline.this.sendUpstream(next, e);
            }
        }
    }
}

