/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.jboss.netty.channel.socket.oio;

import alluxio.shaded.client.org.jboss.netty.channel.Channel;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelException;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelFactory;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelPipeline;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelSink;
import alluxio.shaded.client.org.jboss.netty.channel.Channels;
import alluxio.shaded.client.org.jboss.netty.channel.socket.oio.OioSocketChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.SocketAddress;

class OioAcceptedSocketChannel
extends OioSocketChannel {
    private final PushbackInputStream in;
    private final OutputStream out;

    OioAcceptedSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, Socket socket) {
        super(parent, factory, pipeline, sink, socket);
        try {
            this.in = new PushbackInputStream(socket.getInputStream(), 1);
        }
        catch (IOException e) {
            throw new ChannelException("Failed to obtain an InputStream.", e);
        }
        try {
            this.out = socket.getOutputStream();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to obtain an OutputStream.", e);
        }
        Channels.fireChannelOpen(this);
        Channels.fireChannelBound(this, (SocketAddress)this.getLocalAddress());
    }

    PushbackInputStream getInputStream() {
        return this.in;
    }

    OutputStream getOutputStream() {
        return this.out;
    }
}

