/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.jboss.netty.handler.codec.base64;

import alluxio.shaded.client.org.jboss.netty.buffer.ChannelBuffer;
import alluxio.shaded.client.org.jboss.netty.buffer.ChannelBuffers;
import alluxio.shaded.client.org.jboss.netty.channel.Channel;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelHandler;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.org.jboss.netty.handler.codec.base64.Base64;
import alluxio.shaded.client.org.jboss.netty.handler.codec.base64.Base64Dialect;
import alluxio.shaded.client.org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import alluxio.shaded.client.org.jboss.netty.util.CharsetUtil;

@ChannelHandler.Sharable
public class Base64Decoder
extends OneToOneDecoder {
    private final Base64Dialect dialect;

    public Base64Decoder() {
        this(Base64Dialect.STANDARD);
    }

    public Base64Decoder(Base64Dialect dialect) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        this.dialect = dialect;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof String) {
            msg = ChannelBuffers.copiedBuffer((CharSequence)((String)msg), CharsetUtil.US_ASCII);
        } else if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer src = (ChannelBuffer)msg;
        return Base64.decode(src, src.readerIndex(), src.readableBytes(), this.dialect);
    }
}

