/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.jboss.netty.handler.codec.frame;

import alluxio.shaded.client.org.jboss.netty.buffer.ChannelBuffer;
import alluxio.shaded.client.org.jboss.netty.buffer.ChannelBufferFactory;
import alluxio.shaded.client.org.jboss.netty.channel.Channel;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.org.jboss.netty.handler.codec.frame.FrameDecoder;

public class FixedLengthFrameDecoder
extends FrameDecoder {
    private final int frameLength;
    private final boolean allocateFullBuffer;

    public FixedLengthFrameDecoder(int frameLength) {
        this(frameLength, false);
    }

    public FixedLengthFrameDecoder(int frameLength, boolean allocateFullBuffer) {
        if (frameLength <= 0) {
            throw new IllegalArgumentException("frameLength must be a positive integer: " + frameLength);
        }
        this.frameLength = frameLength;
        this.allocateFullBuffer = allocateFullBuffer;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < this.frameLength) {
            return null;
        }
        ChannelBuffer frame = this.extractFrame(buffer, buffer.readerIndex(), this.frameLength);
        buffer.skipBytes(this.frameLength);
        return frame;
    }

    protected ChannelBuffer newCumulationBuffer(ChannelHandlerContext ctx, int minimumCapacity) {
        ChannelBufferFactory factory = ctx.getChannel().getConfig().getBufferFactory();
        if (this.allocateFullBuffer) {
            return factory.getBuffer(this.frameLength);
        }
        return super.newCumulationBuffer(ctx, minimumCapacity);
    }
}

