/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.jboss.netty.handler.codec.marshalling;

import alluxio.shaded.client.org.jboss.marshalling.ByteOutput;
import alluxio.shaded.client.org.jboss.marshalling.Marshaller;
import alluxio.shaded.client.org.jboss.netty.channel.Channel;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelHandler;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.org.jboss.netty.handler.codec.marshalling.ChannelBufferByteOutput;
import alluxio.shaded.client.org.jboss.netty.handler.codec.marshalling.MarshallerProvider;
import alluxio.shaded.client.org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class CompatibleMarshallingEncoder
extends OneToOneEncoder {
    private final MarshallerProvider provider;

    public CompatibleMarshallingEncoder(MarshallerProvider provider) {
        this.provider = provider;
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        Marshaller marshaller = this.provider.getMarshaller(ctx);
        ChannelBufferByteOutput output = new ChannelBufferByteOutput(ctx.getChannel().getConfig().getBufferFactory(), 256);
        marshaller.start((ByteOutput)output);
        marshaller.writeObject(msg);
        marshaller.finish();
        marshaller.close();
        return output.getBuffer();
    }
}

