/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.jboss.netty.handler.codec.protobuf;

import alluxio.shaded.client.com.google.protobuf.CodedOutputStream;
import alluxio.shaded.client.org.jboss.netty.buffer.ChannelBuffer;
import alluxio.shaded.client.org.jboss.netty.buffer.ChannelBufferOutputStream;
import alluxio.shaded.client.org.jboss.netty.buffer.ChannelBuffers;
import alluxio.shaded.client.org.jboss.netty.channel.Channel;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelHandler;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends OneToOneEncoder {
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        ChannelBuffer body = (ChannelBuffer)msg;
        int length = body.readableBytes();
        ChannelBuffer header = channel.getConfig().getBufferFactory().getBuffer(body.order(), CodedOutputStream.computeRawVarint32Size(length));
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(new ChannelBufferOutputStream(header));
        codedOutputStream.writeRawVarint32(length);
        codedOutputStream.flush();
        return ChannelBuffers.wrappedBuffer(header, body);
    }
}

