/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.jboss.netty.handler.codec.spdy;

import alluxio.shaded.client.org.jboss.netty.buffer.ChannelBuffer;
import alluxio.shaded.client.org.jboss.netty.buffer.ChannelBuffers;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.SpdyCodecUtil;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.SpdyHeaderBlockRawDecoder;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.SpdyProtocolException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class SpdyHeaderBlockZlibDecoder
extends SpdyHeaderBlockRawDecoder {
    private final int version;
    private final byte[] out = new byte[8192];
    private final Inflater decompressor = new Inflater();
    private ChannelBuffer decompressed;

    public SpdyHeaderBlockZlibDecoder(int version, int maxHeaderSize) {
        super(version, maxHeaderSize);
        this.version = version;
    }

    void decode(ChannelBuffer encoded, SpdyHeadersFrame frame) throws Exception {
        int numBytes;
        this.setInput(encoded);
        do {
            numBytes = this.decompress(frame);
        } while (!this.decompressed.readable() && numBytes > 0);
    }

    private void setInput(ChannelBuffer compressed) {
        byte[] in = new byte[compressed.readableBytes()];
        compressed.readBytes(in);
        this.decompressor.setInput(in);
    }

    private int decompress(SpdyHeadersFrame frame) throws Exception {
        if (this.decompressed == null) {
            this.decompressed = ChannelBuffers.dynamicBuffer(8192);
        }
        try {
            int numBytes = this.decompressor.inflate(this.out);
            if (numBytes == 0 && this.decompressor.needsDictionary()) {
                if (this.version < 3) {
                    this.decompressor.setDictionary(SpdyCodecUtil.SPDY2_DICT);
                } else {
                    this.decompressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
                }
                numBytes = this.decompressor.inflate(this.out);
            }
            if (frame != null) {
                this.decompressed.writeBytes(this.out, 0, numBytes);
                super.decode(this.decompressed, frame);
                this.decompressed.discardReadBytes();
            }
            return numBytes;
        }
        catch (DataFormatException e) {
            throw new SpdyProtocolException("Received invalid header block", e);
        }
    }

    void reset() {
        this.decompressed = null;
        super.reset();
    }

    public void end() {
        this.decompressed = null;
        this.decompressor.end();
        super.end();
    }
}

