/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.jboss.netty.handler.codec.spdy;

import alluxio.shaded.client.org.jboss.netty.buffer.ChannelBuffer;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelDownstreamHandler;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelEvent;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelFuture;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelFutureListener;
import alluxio.shaded.client.org.jboss.netty.channel.ChannelHandlerContext;
import alluxio.shaded.client.org.jboss.netty.channel.Channels;
import alluxio.shaded.client.org.jboss.netty.channel.DownstreamMessageEvent;
import alluxio.shaded.client.org.jboss.netty.channel.MessageEvent;
import alluxio.shaded.client.org.jboss.netty.handler.codec.http.HttpChunk;
import alluxio.shaded.client.org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import alluxio.shaded.client.org.jboss.netty.handler.codec.http.HttpHeaders;
import alluxio.shaded.client.org.jboss.netty.handler.codec.http.HttpMessage;
import alluxio.shaded.client.org.jboss.netty.handler.codec.http.HttpRequest;
import alluxio.shaded.client.org.jboss.netty.handler.codec.http.HttpResponse;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.SpdyDataFrame;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.SpdyHeaders;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.SpdyHttpHeaders;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.SpdySynReplyFrame;
import alluxio.shaded.client.org.jboss.netty.handler.codec.spdy.SpdySynStreamFrame;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;

public class SpdyHttpEncoder
implements ChannelDownstreamHandler {
    private final int spdyVersion;
    private volatile int currentStreamId;

    public SpdyHttpEncoder(int version) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unsupported version: " + version);
        }
        this.spdyVersion = version;
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        MessageEvent e = (MessageEvent)evt;
        Object msg = e.getMessage();
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            SpdySynStreamFrame spdySynStreamFrame = this.createSynStreamFrame(httpRequest);
            this.currentStreamId = spdySynStreamFrame.getStreamId();
            ChannelFuture future = this.getMessageFuture(ctx, e, this.currentStreamId, httpRequest);
            Channels.write(ctx, future, spdySynStreamFrame, e.getRemoteAddress());
        } else if (msg instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)msg;
            if (httpResponse.containsHeader("X-SPDY-Associated-To-Stream-ID")) {
                SpdySynStreamFrame spdySynStreamFrame = this.createSynStreamFrame(httpResponse);
                this.currentStreamId = spdySynStreamFrame.getStreamId();
                ChannelFuture future = this.getMessageFuture(ctx, e, this.currentStreamId, httpResponse);
                Channels.write(ctx, future, spdySynStreamFrame, e.getRemoteAddress());
            } else {
                SpdySynReplyFrame spdySynReplyFrame = this.createSynReplyFrame(httpResponse);
                this.currentStreamId = spdySynReplyFrame.getStreamId();
                ChannelFuture future = this.getMessageFuture(ctx, e, this.currentStreamId, httpResponse);
                Channels.write(ctx, future, spdySynReplyFrame, e.getRemoteAddress());
            }
        } else if (msg instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)msg;
            this.writeChunk(ctx, e.getFuture(), this.currentStreamId, chunk, e.getRemoteAddress());
        } else {
            ctx.sendDownstream(evt);
        }
    }

    protected void writeChunk(ChannelHandlerContext ctx, ChannelFuture future, int streamId, HttpChunk chunk, SocketAddress remoteAddress) {
        if (chunk.isLast()) {
            if (chunk instanceof HttpChunkTrailer) {
                HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                List<Map.Entry<String, String>> trailers = trailer.getHeaders();
                if (trailers.isEmpty()) {
                    DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamId);
                    spdyDataFrame.setLast(true);
                    Channels.write(ctx, future, spdyDataFrame, remoteAddress);
                } else {
                    DefaultSpdyHeadersFrame spdyHeadersFrame = new DefaultSpdyHeadersFrame(streamId);
                    spdyHeadersFrame.setLast(true);
                    for (Map.Entry<String, String> entry : trailers) {
                        spdyHeadersFrame.addHeader(entry.getKey(), entry.getValue());
                    }
                    Channels.write(ctx, future, spdyHeadersFrame, remoteAddress);
                }
            } else {
                DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamId);
                spdyDataFrame.setLast(true);
                Channels.write(ctx, future, spdyDataFrame, remoteAddress);
            }
        } else {
            SpdyDataFrame[] spdyDataFrames = this.createSpdyDataFrames(streamId, chunk.getContent());
            ChannelFuture dataFuture = SpdyHttpEncoder.getDataFuture(ctx, future, spdyDataFrames, remoteAddress);
            dataFuture.setSuccess();
        }
    }

    private ChannelFuture getMessageFuture(ChannelHandlerContext ctx, MessageEvent e, int streamId, HttpMessage httpMessage) {
        if (!httpMessage.getContent().readable()) {
            return e.getFuture();
        }
        SpdyDataFrame[] spdyDataFrames = this.createSpdyDataFrames(streamId, httpMessage.getContent());
        if (spdyDataFrames.length > 0) {
            spdyDataFrames[spdyDataFrames.length - 1].setLast(true);
        }
        return SpdyHttpEncoder.getDataFuture(ctx, e.getFuture(), spdyDataFrames, e.getRemoteAddress());
    }

    private static ChannelFuture getDataFuture(ChannelHandlerContext ctx, ChannelFuture future, SpdyDataFrame[] spdyDataFrames, SocketAddress remoteAddress) {
        ChannelFuture dataFuture = future;
        int i = spdyDataFrames.length;
        while (--i >= 0) {
            future = Channels.future(ctx.getChannel());
            future.addListener(new SpdyFrameWriter(ctx, new DownstreamMessageEvent(ctx.getChannel(), dataFuture, spdyDataFrames[i], remoteAddress)));
            dataFuture = future;
        }
        return dataFuture;
    }

    private SpdySynStreamFrame createSynStreamFrame(HttpMessage httpMessage) throws Exception {
        boolean chunked = httpMessage.isChunked();
        int streamId = SpdyHttpHeaders.getStreamId(httpMessage);
        int associatedToStreamId = SpdyHttpHeaders.getAssociatedToStreamId(httpMessage);
        byte priority = SpdyHttpHeaders.getPriority(httpMessage);
        String URL2 = SpdyHttpHeaders.getUrl(httpMessage);
        String scheme = SpdyHttpHeaders.getScheme(httpMessage);
        SpdyHttpHeaders.removeStreamId(httpMessage);
        SpdyHttpHeaders.removeAssociatedToStreamId(httpMessage);
        SpdyHttpHeaders.removePriority(httpMessage);
        SpdyHttpHeaders.removeUrl(httpMessage);
        SpdyHttpHeaders.removeScheme(httpMessage);
        httpMessage.removeHeader("Connection");
        httpMessage.removeHeader("Keep-Alive");
        httpMessage.removeHeader("Proxy-Connection");
        httpMessage.removeHeader("Transfer-Encoding");
        DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(streamId, associatedToStreamId, priority);
        spdySynStreamFrame.setLast(!chunked && !httpMessage.getContent().readable());
        if (httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpMessage;
            SpdyHeaders.setMethod(this.spdyVersion, spdySynStreamFrame, httpRequest.getMethod());
            SpdyHeaders.setUrl(this.spdyVersion, spdySynStreamFrame, httpRequest.getUri());
            SpdyHeaders.setVersion(this.spdyVersion, spdySynStreamFrame, httpMessage.getProtocolVersion());
        }
        if (httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            SpdyHeaders.setStatus(this.spdyVersion, spdySynStreamFrame, httpResponse.getStatus());
            SpdyHeaders.setUrl(this.spdyVersion, spdySynStreamFrame, URL2);
            SpdyHeaders.setVersion(this.spdyVersion, spdySynStreamFrame, httpMessage.getProtocolVersion());
            spdySynStreamFrame.setUnidirectional(true);
        }
        if (this.spdyVersion >= 3) {
            String host = HttpHeaders.getHost(httpMessage);
            httpMessage.removeHeader("Host");
            SpdyHeaders.setHost(spdySynStreamFrame, host);
        }
        if (scheme == null) {
            scheme = "https";
        }
        SpdyHeaders.setScheme(this.spdyVersion, spdySynStreamFrame, scheme);
        for (Map.Entry<String, String> entry : httpMessage.getHeaders()) {
            spdySynStreamFrame.addHeader(entry.getKey(), entry.getValue());
        }
        return spdySynStreamFrame;
    }

    private SpdySynReplyFrame createSynReplyFrame(HttpResponse httpResponse) throws Exception {
        boolean chunked = httpResponse.isChunked();
        int streamId = SpdyHttpHeaders.getStreamId(httpResponse);
        SpdyHttpHeaders.removeStreamId(httpResponse);
        httpResponse.removeHeader("Connection");
        httpResponse.removeHeader("Keep-Alive");
        httpResponse.removeHeader("Proxy-Connection");
        httpResponse.removeHeader("Transfer-Encoding");
        DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamId);
        spdySynReplyFrame.setLast(!chunked && !httpResponse.getContent().readable());
        SpdyHeaders.setStatus(this.spdyVersion, spdySynReplyFrame, httpResponse.getStatus());
        SpdyHeaders.setVersion(this.spdyVersion, spdySynReplyFrame, httpResponse.getProtocolVersion());
        for (Map.Entry<String, String> entry : httpResponse.getHeaders()) {
            spdySynReplyFrame.addHeader(entry.getKey(), entry.getValue());
        }
        return spdySynReplyFrame;
    }

    private SpdyDataFrame[] createSpdyDataFrames(int streamId, ChannelBuffer content) {
        int readableBytes = content.readableBytes();
        int count = readableBytes / 0xFFFFFF;
        if (readableBytes % 0xFFFFFF > 0) {
            ++count;
        }
        SpdyDataFrame[] spdyDataFrames = new SpdyDataFrame[count];
        for (int i = 0; i < count; ++i) {
            DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamId);
            int dataSize = Math.min(content.readableBytes(), 0xFFFFFF);
            spdyDataFrame.setData(content.readSlice(dataSize));
            spdyDataFrames[i] = spdyDataFrame;
        }
        return spdyDataFrames;
    }

    private static class SpdyFrameWriter
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final MessageEvent e;

        SpdyFrameWriter(ChannelHandlerContext ctx, MessageEvent e) {
            this.ctx = ctx;
            this.e = e;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                this.ctx.sendDownstream(this.e);
            } else if (future.isCancelled()) {
                this.e.getFuture().cancel();
            } else {
                this.e.getFuture().setFailure(future.getCause());
            }
        }
    }
}

