/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.proto.dataserver.Protocol;
import alluxio.security.group.GroupMappingService;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.base.Splitter;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.com.google.protobuf.ByteString;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.ShellUtils;
import alluxio.util.SleepUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.util.proto.ProtoUtils;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CommonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonUtils.class);
    private static final String ALPHANUM = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final Random RANDOM = new Random();
    public static final AtomicReference<ProcessType> PROCESS_TYPE = new AtomicReference<ProcessType>(ProcessType.CLIENT);

    public static Thread createProgressThread(PrintStream stream) {
        return CommonUtils.createProgressThread(2000L, stream);
    }

    public static Thread createProgressThread(long intervalMs, PrintStream stream) {
        Thread t = new Thread(() -> {
            while (true) {
                CommonUtils.sleepMs(intervalMs);
                if (Thread.interrupted()) {
                    return;
                }
                stream.print(".");
            }
        });
        t.setDaemon(true);
        return t;
    }

    public static long getCurrentMs() {
        return System.currentTimeMillis();
    }

    public static String getTmpDir(List<String> tmpDirs) {
        Preconditions.checkState(!tmpDirs.isEmpty(), "No temporary directories available");
        if (tmpDirs.size() == 1) {
            return tmpDirs.get(0);
        }
        return tmpDirs.get(RANDOM.nextInt(tmpDirs.size()));
    }

    public static String getWorkerDataDirectory(String storageDir, AlluxioConfiguration conf) {
        return PathUtils.concatPath((Object)storageDir.trim(), (Object)conf.get(PropertyKey.WORKER_DATA_FOLDER));
    }

    public static <T> String listToString(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (T s2 : list) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(s2);
        }
        return sb.toString();
    }

    public static <T> String argsToString(String separator, T ... args) {
        StringBuilder sb = new StringBuilder();
        for (T s2 : args) {
            if (sb.length() != 0) {
                sb.append(separator);
            }
            sb.append(s2);
        }
        return sb.toString();
    }

    public static String[] toStringArray(ArrayList<String> src) {
        String[] ret = new String[src.size()];
        return src.toArray(ret);
    }

    public static String randomAlphaNumString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(ALPHANUM.charAt(RANDOM.nextInt(ALPHANUM.length())));
        }
        return sb.toString();
    }

    public static byte[] randomBytes(int length) {
        byte[] result = new byte[length];
        RANDOM.nextBytes(result);
        return result;
    }

    public static void sleepMs(long timeMs) {
        SleepUtils.sleepMs(timeMs);
    }

    public static void sleepMs(Logger logger, long timeMs) {
        SleepUtils.sleepMs(logger, timeMs);
    }

    public static void warmUpLoop() {
        for (int k = 0; k < 10000000; ++k) {
        }
    }

    public static <T> T createNewClassInstance(Class<T> cls, Class<?>[] ctorClassArgs, Object[] ctorArgs) {
        try {
            if (ctorClassArgs == null) {
                return cls.newInstance();
            }
            Constructor<T> ctor = cls.getConstructor(ctorClassArgs);
            return ctor.newInstance(ctorArgs);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> getUnixGroups(String user) throws IOException {
        String result;
        ArrayList<String> groups = new ArrayList<String>();
        try {
            result = ShellUtils.execCommand(ShellUtils.getGroupsForUserCommand(user));
        }
        catch (ShellUtils.ExitCodeException e) {
            LOG.warn("got exception trying to get groups for user " + user + ": " + e.getMessage());
            return groups;
        }
        StringTokenizer tokenizer = new StringTokenizer(result, "[ \t\n\r\f]");
        while (tokenizer.hasMoreTokens()) {
            groups.add(tokenizer.nextToken());
        }
        return groups;
    }

    public static void waitFor(String description, Supplier<Boolean> condition) throws InterruptedException, TimeoutException {
        CommonUtils.waitFor(description, condition, WaitForOptions.defaults());
    }

    public static void waitFor(String description, Supplier<Boolean> condition, WaitForOptions options) throws InterruptedException, TimeoutException {
        CommonUtils.waitForResult(description, () -> (Boolean)condition.get() != false ? Boolean.valueOf(true) : null, options);
    }

    public static <T> T waitForResult(String description, Supplier<T> operation, WaitForOptions options) throws InterruptedException, TimeoutException {
        T t;
        long start = System.currentTimeMillis();
        int interval = options.getInterval();
        int timeout = options.getTimeoutMs();
        while ((t = operation.get()) == null) {
            if (timeout != -1 && System.currentTimeMillis() - start > (long)timeout) {
                throw new TimeoutException("Timed out waiting for " + description + " options: " + options);
            }
            Thread.sleep(interval);
        }
        return t;
    }

    public static String getPrimaryGroupName(String userName, AlluxioConfiguration conf) throws IOException {
        List<String> groups = CommonUtils.getGroups(userName, conf);
        return groups != null && groups.size() > 0 ? groups.get(0) : "";
    }

    public static List<String> getGroups(String userName, AlluxioConfiguration conf) throws IOException {
        GroupMappingService groupMappingService = GroupMappingService.Factory.get(conf);
        return groupMappingService.getGroups(userName);
    }

    public static String stripSuffixIfPresent(String key, String suffix) {
        if (key.endsWith(suffix)) {
            return key.substring(0, key.length() - suffix.length());
        }
        return key;
    }

    public static String stripPrefixIfPresent(String key, String prefix) {
        if (key.startsWith(prefix)) {
            return key.substring(prefix.length());
        }
        return key;
    }

    public static String stripLeadingAndTrailingQuotes(String str) {
        int length = str.length();
        if (length > 1 && str.startsWith("\"") && str.endsWith("\"")) {
            str = str.substring(1, length - 1);
        }
        return str;
    }

    public static String getValueFromStaticMapping(String mapping, String key) {
        Map<String, String> m3 = Splitter.on(";").omitEmptyStrings().trimResults().withKeyValueSeparator("=").split(mapping);
        return m3.get(key);
    }

    public static Throwable getRootCause(Throwable e) {
        while (e.getCause() != null && !(e.getCause() instanceof StatusRuntimeException)) {
            e = e.getCause();
        }
        return e;
    }

    public static IOException castToIOException(Throwable e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    public static <T> Iterator<T> singleElementIterator(final T element) {
        return new Iterator<T>(){
            private boolean mHasNext = true;

            @Override
            public boolean hasNext() {
                return this.mHasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.mHasNext = false;
                return element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported.");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void invokeAll(List<Callable<T>> callables, long timeoutMs) throws TimeoutException, ExecutionException {
        long endMs = System.currentTimeMillis() + timeoutMs;
        ExecutorService service = Executors.newCachedThreadPool();
        try {
            ArrayList<Future<T>> pending = new ArrayList<Future<T>>();
            for (Callable<T> c : callables) {
                pending.add(service.submit(c));
            }
            while (!pending.isEmpty()) {
                Iterator it = pending.iterator();
                while (it.hasNext()) {
                    Future future = (Future)it.next();
                    if (!future.isDone()) continue;
                    try {
                        future.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                    it.remove();
                }
                if (pending.isEmpty()) {
                    break;
                }
                long remainingMs = endMs - System.currentTimeMillis();
                if (remainingMs <= 0L) {
                    throw new TimeoutException(String.format("Timed out after %dms", timeoutMs - remainingMs));
                }
                CommonUtils.sleepMs(Math.min(remainingMs, 50L));
            }
        }
        finally {
            service.shutdownNow();
        }
    }

    public static RuntimeException closeAndRethrow(Closer closer, Throwable t) throws IOException {
        try {
            throw closer.rethrow(t);
        }
        catch (Throwable throwable) {
            closer.close();
            throw throwable;
        }
    }

    public static void unwrapResponse(Protocol.Response response) throws AlluxioStatusException {
        Status status = ProtoUtils.fromProto(response.getStatus());
        if (status != Status.OK) {
            throw AlluxioStatusException.from(status.withDescription(response.getMessage()));
        }
    }

    public static void unwrapResponseFrom(Protocol.Response response, Channel channel) throws AlluxioStatusException {
        Status status = ProtoUtils.fromProto(response.getStatus());
        if (status != Status.OK) {
            throw AlluxioStatusException.from(status.withDescription(String.format("Channel to %s: %s", channel.remoteAddress(), response.getMessage())));
        }
    }

    public static boolean isLocalHost(WorkerNetAddress address, AlluxioConfiguration conf) {
        return address.getHost().equals(NetworkAddressUtils.getClientHostName(conf));
    }

    public static String convertMsToDate(long millis, String dateFormatPattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatPattern);
        return dateFormat.format(new Date(millis));
    }

    public static String convertMsToClockTime(long millis) {
        Preconditions.checkArgument(millis >= 0L, "Negative values %s are not supported to convert to clock time.", millis);
        long days = millis / 86400000L;
        long hours = millis % 86400000L / 3600000L;
        long mins = millis % 3600000L / 60000L;
        long secs = millis % 60000L / 1000L;
        return String.format("%d day(s), %d hour(s), %d minute(s), and %d second(s)", days, hours, mins, secs);
    }

    public static Map<String, ByteString> convertToByteString(Map<String, byte[]> input) {
        if (input == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ByteString> output = new HashMap<String, ByteString>(input.size());
        input.forEach((k, v) -> output.put((String)k, ByteString.copyFrom(v)));
        return output;
    }

    public static Map<String, byte[]> convertFromByteString(Map<String, ByteString> input) {
        if (input == null) {
            return Collections.emptyMap();
        }
        HashMap<String, byte[]> output = new HashMap<String, byte[]>(input.size());
        input.forEach((k, v) -> output.put((String)k, v.toByteArray()));
        return output;
    }

    private CommonUtils() {
    }

    public static enum ProcessType {
        JOB_MASTER,
        JOB_WORKER,
        CLIENT,
        MASTER,
        PROXY,
        WORKER;

    }
}

