/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.FormatUtils;
import alluxio.util.OSUtils;
import alluxio.util.UnixMountInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ShellUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ShellUtils.class);
    public static final String COMMON_SSH_OPTS = "-o StrictHostKeyChecking=no -o ConnectTimeout=5";
    public static final String SET_PERMISSION_COMMAND = "chmod";
    public static final String MOUNT_COMMAND = "mount";
    public static final String TOKEN_SEPARATOR_REGEX = "[ \t\n\r\f]";

    public static String[] getGroupsForUserCommand(String user) {
        return new String[]{"bash", "-c", "id -gn " + user + "; id -Gn " + user};
    }

    public static String[] getSetPermissionCommand(String perm, String filePath) {
        return new String[]{SET_PERMISSION_COMMAND, perm, filePath};
    }

    public static List<UnixMountInfo> getUnixMountInfo() throws IOException {
        Preconditions.checkState(OSUtils.isLinux() || OSUtils.isMacOS());
        String output = ShellUtils.execCommand(MOUNT_COMMAND);
        ArrayList<UnixMountInfo> mountInfo = new ArrayList<UnixMountInfo>();
        for (String line : output.split("\n")) {
            mountInfo.add(ShellUtils.parseMountInfo(line));
        }
        return mountInfo;
    }

    public static UnixMountInfo parseMountInfo(String line) {
        String lineWithoutType;
        UnixMountInfo.Builder builder = new UnixMountInfo.Builder();
        Matcher matcher = Pattern.compile(".* (type \\w+ ).*").matcher(line);
        if (matcher.matches()) {
            String match = matcher.group(1);
            builder.setFsType(match.replace("type", "").trim());
            lineWithoutType = line.replace(match, "");
        } else {
            lineWithoutType = line;
        }
        matcher = Pattern.compile("(.*) on (.*) \\((.*)\\)").matcher(lineWithoutType);
        if (!matcher.matches()) {
            LOG.debug("Unable to parse output of 'mount': {}", (Object)line);
            return builder.build();
        }
        builder.setDeviceSpec(matcher.group(1));
        builder.setMountPoint(matcher.group(2));
        builder.setOptions(ShellUtils.parseUnixMountOptions(matcher.group(3)));
        return builder.build();
    }

    private static UnixMountInfo.Options parseUnixMountOptions(String line) {
        UnixMountInfo.Options.Builder builder = new UnixMountInfo.Options.Builder();
        for (String option : line.split(",")) {
            Matcher matcher = Pattern.compile("(.*)=(.*)").matcher(option.trim());
            if (!matcher.matches() || !matcher.group(1).equalsIgnoreCase("size")) continue;
            try {
                builder.setSize(FormatUtils.parseSpaceSize(matcher.group(2)));
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Failed to parse mount point size: {}", (Throwable)e);
            }
        }
        return builder.build();
    }

    public static String execCommand(String ... cmd) throws IOException {
        return new Command(cmd).run();
    }

    private ShellUtils() {
    }

    public static class ExitCodeException
    extends IOException {
        private static final long serialVersionUID = -6520494427049734809L;
        private final int mExitCode;

        public ExitCodeException(int exitCode, String message) {
            super(message);
            this.mExitCode = exitCode;
        }

        public int getExitCode() {
            return this.mExitCode;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ExitCodeException ");
            sb.append("exitCode=").append(this.mExitCode).append(": ");
            sb.append(super.getMessage());
            return sb.toString();
        }
    }

    @NotThreadSafe
    private static final class Command {
        private String[] mCommand;

        private Command(String[] execString) {
            this.mCommand = (String[])execString.clone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String run() throws ExitCodeException, IOException {
            Process process = new ProcessBuilder(this.mCommand).redirectErrorStream(true).start();
            BufferedReader inReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
            try {
                StringBuilder output = new StringBuilder();
                String line = inReader.readLine();
                while (line != null) {
                    output.append(line);
                    output.append("\n");
                    line = inReader.readLine();
                }
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    throw new ExitCodeException(exitCode, output.toString());
                }
                String string = output.toString();
                return string;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
            finally {
                try {
                    InputStream stdout;
                    InputStream inputStream = stdout = process.getInputStream();
                    synchronized (inputStream) {
                        inReader.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Error while closing the input stream", (Throwable)e);
                }
                process.destroy();
            }
        }
    }
}

