/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Optional;

public final class UnixMountInfo {
    private final Optional<String> mDeviceSpec;
    private final Optional<String> mMountPoint;
    private final Optional<String> mFsType;
    private final Options mMountOptions;

    private UnixMountInfo(String deviceSpec, String mountPoint, String fsType, Options options) {
        this.mDeviceSpec = Optional.fromNullable(deviceSpec);
        this.mMountPoint = Optional.fromNullable(mountPoint);
        this.mFsType = Optional.fromNullable(fsType);
        this.mMountOptions = options;
    }

    public Optional<String> getDeviceSpec() {
        return this.mDeviceSpec;
    }

    public Optional<String> getMountPoint() {
        return this.mMountPoint;
    }

    public Optional<String> getFsType() {
        return this.mFsType;
    }

    public Options getOptions() {
        return this.mMountOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnixMountInfo)) {
            return false;
        }
        UnixMountInfo that = (UnixMountInfo)o;
        return Objects.equal(this.mDeviceSpec, that.mDeviceSpec) && Objects.equal(this.mMountPoint, that.mMountPoint) && Objects.equal(this.mFsType, that.mFsType) && Objects.equal(this.mMountOptions, that.mMountOptions);
    }

    public int hashCode() {
        return Objects.hashCode(this.mDeviceSpec, this.mMountPoint, this.mFsType, this.mMountOptions);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("deviceSpec", this.mDeviceSpec).add("mountPoint", this.mMountPoint).add("fsType", this.mFsType).add("options", this.mMountOptions).toString();
    }

    public static final class Options {
        private final Optional<Long> mSize;

        private Options(Long size) {
            this.mSize = Optional.fromNullable(size);
        }

        public Optional<Long> getSize() {
            return this.mSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options that = (Options)o;
            return Objects.equal(this.mSize, that.mSize);
        }

        public int hashCode() {
            return Objects.hashCode(this.mSize);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("size", this.mSize).toString();
        }

        public static class Builder {
            private Long mSize;

            public Builder setSize(Long size) {
                this.mSize = size;
                return this;
            }

            public Options build() {
                return new Options(this.mSize);
            }
        }
    }

    public static class Builder {
        private String mDeviceSpec;
        private String mMountPoint;
        private String mFsType;
        private Options mOptions;

        public Builder setDeviceSpec(String deviceSpec) {
            this.mDeviceSpec = deviceSpec;
            return this;
        }

        public Builder setMountPoint(String mountPoint) {
            this.mMountPoint = mountPoint;
            return this;
        }

        public Builder setFsType(String fsType) {
            this.mFsType = fsType;
            return this;
        }

        public Builder setOptions(Options options) {
            this.mOptions = options;
            return this;
        }

        public UnixMountInfo build() {
            return new UnixMountInfo(this.mDeviceSpec, this.mMountPoint, this.mFsType, this.mOptions);
        }
    }
}

