/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.AlluxioURI;
import alluxio.grpc.BackupPResponse;
import alluxio.shaded.client.com.google.common.base.Preconditions;

public class BackupResponse {
    private AlluxioURI mBackupUri;
    private String mHostname;

    public BackupResponse(AlluxioURI backupUri, String hostname) {
        this.mBackupUri = Preconditions.checkNotNull(backupUri, "backupUri");
        this.mHostname = Preconditions.checkNotNull(hostname, "hostname");
    }

    public static BackupResponse fromProto(BackupPResponse pResp) {
        return new BackupResponse(new AlluxioURI(pResp.getBackupUri()), pResp.getHostname());
    }

    public BackupPResponse toProto() {
        return BackupPResponse.newBuilder().setBackupUri(this.mBackupUri.toString()).setHostname(this.mHostname).build();
    }

    public AlluxioURI getBackupUri() {
        return this.mBackupUri;
    }

    public String getHostname() {
        return this.mHostname;
    }
}

