/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.metrics;

import alluxio.client.metrics.MetricsMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.grpc.ClientMetrics;
import alluxio.grpc.Metric;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.logging.SamplingLogger;
import alluxio.util.network.NetworkAddressUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ClientMasterSync {
    private static final Logger SAMPLING_LOG = new SamplingLogger(LoggerFactory.getLogger(ClientMasterSync.class), 30000L);
    private final MetricsMasterClient mMasterClient;
    private final String mApplicationId;
    private final AlluxioConfiguration mConf;

    public ClientMasterSync(String appId, MetricsMasterClient masterClient, AlluxioConfiguration conf) {
        this.mMasterClient = Preconditions.checkNotNull(masterClient, "masterClient");
        this.mApplicationId = Preconditions.checkNotNull(appId);
        this.mConf = conf;
    }

    public synchronized void heartbeat() {
        ArrayList<ClientMetrics> fsClientMetrics = new ArrayList<ClientMetrics>();
        String hostname = NetworkAddressUtils.getClientHostName(this.mConf);
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (Metric metric : MetricsSystem.reportClientMetrics()) {
            metrics.add(metric.toBuilder().setInstanceId(this.mApplicationId).build());
        }
        fsClientMetrics.add(ClientMetrics.newBuilder().setHostname(hostname).setClientId(this.mApplicationId).addAllMetrics(metrics).build());
        try {
            this.mMasterClient.heartbeat(fsClientMetrics);
        }
        catch (IOException e) {
            SAMPLING_LOG.warn("Failed to send metrics to master: {}", (Object)e.toString());
        }
    }
}

