/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf.path;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TrieNode {
    private Map<String, TrieNode> mChildren = new HashMap<String, TrieNode>();
    private boolean mIsTerminal = false;

    public TrieNode insert(String path) {
        TrieNode current = this;
        for (String component : path.split("/")) {
            if (!current.mChildren.containsKey(component)) {
                current.mChildren.put(component, new TrieNode());
            }
            current = current.mChildren.get(component);
        }
        current.mIsTerminal = true;
        return current;
    }

    public List<TrieNode> search(String path) {
        ArrayList<TrieNode> terminal = new ArrayList<TrieNode>();
        TrieNode current = this;
        if (current.mIsTerminal) {
            terminal.add(current);
        }
        for (String component : path.split("/")) {
            if (!current.mChildren.containsKey(component)) break;
            current = current.mChildren.get(component);
            if (!current.mIsTerminal) continue;
            terminal.add(current);
        }
        return terminal;
    }
}

