/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.GrpcChannel;
import alluxio.grpc.GrpcChannelKey;
import alluxio.grpc.GrpcManagedChannelPool;
import alluxio.grpc.GrpcServerAddress;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.ChannelAuthenticator;
import alluxio.shaded.client.io.grpc.ManagedChannel;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.EventLoopGroup;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;

public final class GrpcChannelBuilder {
    private GrpcChannelKey mChannelKey;
    private boolean mUseSubject;
    private Subject mParentSubject;
    private String mUserName;
    private String mPassword;
    private String mImpersonationUser;
    private boolean mAuthenticateChannel;
    private AlluxioConfiguration mConfiguration;

    private GrpcChannelBuilder(GrpcServerAddress address, AlluxioConfiguration conf) {
        this.mConfiguration = conf;
        this.mChannelKey = GrpcChannelKey.create(conf);
        this.mChannelKey.setServerAddress(address);
        this.mChannelKey.setMaxInboundMessageSize((int)this.mConfiguration.getBytes(PropertyKey.USER_NETWORK_MAX_INBOUND_MESSAGE_SIZE));
        this.mUseSubject = true;
        this.mAuthenticateChannel = true;
    }

    public static GrpcChannelBuilder newBuilder(GrpcServerAddress address, AlluxioConfiguration conf) {
        return new GrpcChannelBuilder(address, conf);
    }

    public GrpcChannelBuilder setClientType(String clientType) {
        this.mChannelKey.setClientType(clientType);
        return this;
    }

    public GrpcChannelBuilder setSubject(Subject subject) {
        this.mParentSubject = subject;
        this.mUseSubject = true;
        return this;
    }

    public GrpcChannelBuilder setCredentials(String userName, String password, String impersonationUser) {
        this.mUserName = userName;
        this.mPassword = password;
        this.mImpersonationUser = impersonationUser;
        this.mUseSubject = false;
        return this;
    }

    public GrpcChannelBuilder disableAuthentication() {
        this.mAuthenticateChannel = false;
        return this;
    }

    public GrpcChannelBuilder setKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        this.mChannelKey.setKeepAliveTime(keepAliveTime, timeUnit);
        return this;
    }

    public GrpcChannelBuilder setKeepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        this.mChannelKey.setKeepAliveTimeout(keepAliveTimeout, timeUnit);
        return this;
    }

    public GrpcChannelBuilder setMaxInboundMessageSize(int maxInboundMessaageSize) {
        this.mChannelKey.setMaxInboundMessageSize(maxInboundMessaageSize);
        return this;
    }

    public GrpcChannelBuilder setFlowControlWindow(int flowControlWindow) {
        this.mChannelKey.setFlowControlWindow(flowControlWindow);
        return this;
    }

    public GrpcChannelBuilder setChannelType(Class<? extends Channel> channelType) {
        this.mChannelKey.setChannelType(channelType);
        return this;
    }

    public GrpcChannelBuilder setEventLoopGroup(EventLoopGroup group) {
        this.mChannelKey.setEventLoopGroup(group);
        return this;
    }

    public GrpcChannelBuilder setPoolingStrategy(GrpcChannelKey.PoolingStrategy strategy) {
        this.mChannelKey.setPoolingStrategy(strategy);
        return this;
    }

    public GrpcChannel build() throws AlluxioStatusException {
        ManagedChannel underlyingChannel = GrpcManagedChannelPool.INSTANCE().acquireManagedChannel(this.mChannelKey, this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_HEALTH_CHECK_TIMEOUT), this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_SHUTDOWN_TIMEOUT));
        try {
            AuthType authType = this.mConfiguration.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
            if (this.mAuthenticateChannel && authType != AuthType.NOSASL) {
                ChannelAuthenticator channelAuthenticator = this.mUseSubject ? new ChannelAuthenticator(this.mChannelKey, this.mParentSubject, this.mConfiguration) : new ChannelAuthenticator(this.mChannelKey, this.mUserName, this.mPassword, this.mImpersonationUser, this.mConfiguration.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class), this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_AUTH_TIMEOUT));
                return new GrpcChannel(this.mChannelKey, channelAuthenticator.authenticate(underlyingChannel), this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_SHUTDOWN_TIMEOUT));
            }
            return new GrpcChannel(this.mChannelKey, underlyingChannel, this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_SHUTDOWN_TIMEOUT));
        }
        catch (Exception e) {
            GrpcManagedChannelPool.INSTANCE().releaseManagedChannel(this.mChannelKey, this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_SHUTDOWN_TIMEOUT));
            if (e instanceof UnavailableException) {
                throw new UnavailableException(String.format("Target Unavailable. %s", this.mChannelKey.toStringShort()), e.getCause());
            }
            throw e;
        }
    }
}

