/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.retry.ExponentialBackoffRetry;
import alluxio.retry.RetryUtils;
import alluxio.security.authentication.AuthenticationServer;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.io.grpc.Server;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public final class GrpcServer {
    private Server mServer;
    private AuthenticationServer mAuthServer;
    private boolean mStarted = false;
    private final long mServerShutdownTimeoutMs;

    public GrpcServer(Server server, AuthenticationServer authServer, long serverShutdownTimeoutMs) {
        this.mServer = server;
        this.mAuthServer = authServer;
        this.mServerShutdownTimeoutMs = serverShutdownTimeoutMs;
    }

    @VisibleForTesting
    public AuthenticationServer getAuthenticationServer() {
        return this.mAuthServer;
    }

    public GrpcServer start() throws IOException {
        RetryUtils.retry("Starting gRPC server", () -> this.mServer.start(), new ExponentialBackoffRetry(100, 500, 5));
        this.mStarted = true;
        return this;
    }

    public int getBindPort() {
        return this.mServer.getPort();
    }

    public boolean shutdown() {
        this.mServer.shutdown();
        if (this.mAuthServer != null) {
            this.mAuthServer.close();
        }
        try {
            boolean bl = this.mServer.awaitTermination(this.mServerShutdownTimeoutMs, TimeUnit.MILLISECONDS);
            return bl;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServer.shutdownNow();
        }
    }

    public void awaitTermination() {
        try {
            this.mServer.awaitTermination();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isServing() {
        return this.mStarted && !this.mServer.isShutdown() || !this.mServer.isTerminated();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("Server", this.mServer).add("AuthServerType", this.mAuthServer.getClass().getSimpleName()).toString();
    }
}

