/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.grpc.Metric;
import alluxio.grpc.MetricType;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Metric
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Metric.class);
    private static final long serialVersionUID = -2236393414222298333L;
    private static final String ID_SEPARATOR = "-id:";
    public static final String TAG_SEPARATOR = ":";
    private static final ConcurrentHashMap<UserMetricKey, String> CACHED_METRICS = new ConcurrentHashMap();
    private final MetricsSystem.InstanceType mInstanceType;
    private final String mHostname;
    private final String mName;
    private final Double mValue;
    private final MetricType mMetricType;
    private String mInstanceId;
    private final Map<String, String> mTags;

    public Metric(MetricsSystem.InstanceType instanceType, String hostname, MetricType metricType, String name, Double value) {
        this(instanceType, hostname, null, metricType, name, value);
    }

    public Metric(MetricsSystem.InstanceType instanceType, String hostname, String id, MetricType metricType, String name, Double value) {
        Preconditions.checkNotNull(name, "name");
        this.mInstanceType = instanceType;
        this.mHostname = hostname;
        this.mInstanceId = id;
        this.mMetricType = metricType;
        this.mName = name;
        this.mValue = value;
        this.mTags = new LinkedHashMap<String, String>();
    }

    public MetricsSystem.InstanceType getInstanceType() {
        return this.mInstanceType;
    }

    public void addTag(String name, String value) {
        this.mTags.put(name, value);
    }

    public String getHostname() {
        return this.mHostname;
    }

    public MetricType getMetricType() {
        return this.mMetricType;
    }

    public String getName() {
        return this.mName;
    }

    public double getValue() {
        return this.mValue;
    }

    public String getInstanceId() {
        return this.mInstanceId;
    }

    public Map<String, String> getTags() {
        return this.mTags;
    }

    public void setInstanceId(String instanceId) {
        this.mInstanceId = instanceId;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Metric)) {
            return false;
        }
        Metric metric = (Metric)other;
        return Objects.equal(this.getFullMetricName(), metric.getFullMetricName()) && Objects.equal(this.mValue, metric.mValue);
    }

    public int hashCode() {
        return Objects.hashCode(this.getFullMetricName(), this.mValue);
    }

    public String getFullMetricName() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.mInstanceType).append('.');
        if (this.mHostname != null) {
            sb.append(this.mHostname);
            if (this.mInstanceId != null) {
                sb.append(ID_SEPARATOR).append(this.mInstanceId);
            }
            sb.append('.');
        }
        sb.append(this.mName);
        for (Map.Entry<String, String> entry : this.mTags.entrySet()) {
            sb.append('.').append(entry.getKey()).append(TAG_SEPARATOR).append(entry.getValue());
        }
        return sb.toString();
    }

    public alluxio.grpc.Metric toProto() {
        Metric.Builder metric = alluxio.grpc.Metric.newBuilder();
        metric.setInstance(this.mInstanceType.toString()).setHostname(this.mHostname).setMetricType(this.mMetricType).setName(this.mName).setValue(this.mValue).putAllTags(this.mTags);
        if (this.mInstanceId != null && !this.mInstanceId.isEmpty()) {
            metric.setInstanceId(this.mInstanceId);
        }
        return metric.build();
    }

    public static String getMetricNameWithTags(String name, String ... tags) {
        Preconditions.checkArgument(tags.length % 2 == 0, "The tag arguments should be tag name and tag value pairs");
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        for (int i = 0; i < tags.length; i += 2) {
            sb.append('.').append(tags[i]).append(TAG_SEPARATOR).append(tags[i + 1]);
        }
        return sb.toString();
    }

    public static String getMetricNameWithUserTag(String metricName, String userName) {
        UserMetricKey k = new UserMetricKey(metricName, userName);
        String result = CACHED_METRICS.get(k);
        if (result != null) {
            return result;
        }
        return CACHED_METRICS.computeIfAbsent(k, key -> metricName + "." + "User" + TAG_SEPARATOR + userName);
    }

    public static Metric from(String fullName, double value, MetricType metricType) {
        String[] pieces = fullName.split("\\.");
        Preconditions.checkArgument(pieces.length > 1, "Incorrect metrics name: %s.", (Object)fullName);
        String hostname = null;
        String id = null;
        String name = null;
        int tagStartIdx = 0;
        if (pieces[0].equals(MetricsSystem.InstanceType.MASTER.toString()) || pieces[0].equals("cluster")) {
            name = pieces[1];
            tagStartIdx = 2;
        } else {
            if (pieces[1].contains(ID_SEPARATOR)) {
                String[] ids = pieces[1].split(ID_SEPARATOR);
                hostname = ids[0];
                id = ids[1];
            } else {
                hostname = pieces[1];
            }
            name = pieces[2];
            tagStartIdx = 3;
        }
        MetricsSystem.InstanceType instance = MetricsSystem.InstanceType.fromString(pieces[0]);
        Metric metric = new Metric(instance, hostname, id, metricType, name, value);
        for (int i = tagStartIdx; i < pieces.length; ++i) {
            String tagStr = pieces[i];
            if (!tagStr.contains(TAG_SEPARATOR)) continue;
            int tagSeparatorIdx = tagStr.indexOf(TAG_SEPARATOR);
            metric.addTag(tagStr.substring(0, tagSeparatorIdx), tagStr.substring(tagSeparatorIdx + 1));
        }
        return metric;
    }

    public static Metric fromProto(alluxio.grpc.Metric metric) {
        Metric created = new Metric(MetricsSystem.InstanceType.fromString(metric.getInstance()), metric.getHostname(), metric.hasInstanceId() ? metric.getInstanceId() : null, metric.getMetricType(), metric.getName(), metric.getValue());
        for (Map.Entry<String, String> entry : metric.getTagsMap().entrySet()) {
            created.addTag(entry.getKey(), entry.getValue());
        }
        return created;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("hostname", this.mHostname).add("instanceId", this.mInstanceId).add("instanceType", (Object)this.mInstanceType).add("metricType", this.mMetricType).add("name", this.mName).add("tags", this.mTags).add("value", this.mValue).toString();
    }

    private static class UserMetricKey {
        private String mMetric;
        private String mUser;

        private UserMetricKey(String metricName, String userName) {
            this.mMetric = metricName;
            this.mUser = userName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UserMetricKey)) {
                return false;
            }
            UserMetricKey that = (UserMetricKey)o;
            return Objects.equal(this.mMetric, that.mMetric) && Objects.equal(this.mUser, that.mUser);
        }

        public int hashCode() {
            return Objects.hashCode(this.mMetric, this.mUser);
        }
    }
}

