/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.exception.status.UnauthenticatedException;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authentication.AuthenticatedUserInfo;
import alluxio.security.authentication.AuthenticationServer;
import alluxio.security.authentication.ChannelIdInjector;
import alluxio.shaded.client.io.grpc.ForwardingServerCallListener;
import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.ServerCall;
import alluxio.shaded.client.io.grpc.ServerCallHandler;
import alluxio.shaded.client.io.grpc.ServerInterceptor;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class AuthenticatedUserInjector
implements ServerInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticatedUserInjector.class);
    private final AuthenticationServer mAuthenticationServer;

    public AuthenticatedUserInjector(AuthenticationServer authenticationServer) {
        this.mAuthenticationServer = authenticationServer;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, final Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        this.authenticateCall(call, headers);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

            @Override
            public void onHalfClose() {
                if (AuthenticatedUserInjector.this.authenticateCall(call, headers)) {
                    super.onHalfClose();
                }
            }
        };
    }

    private <ReqT, RespT> boolean authenticateCall(ServerCall<ReqT, RespT> call, Metadata headers) {
        if (call.isCancelled()) {
            LOG.debug("Server call has been cancelled: %s", (Object)call.getMethodDescriptor().getFullMethodName());
            return false;
        }
        UUID channelId = headers.get(ChannelIdInjector.S_CLIENT_ID_KEY);
        boolean callAuthenticated = false;
        if (channelId != null) {
            try {
                AuthenticatedUserInfo userInfo = this.mAuthenticationServer.getUserInfoForChannel(channelId);
                if (userInfo != null) {
                    AuthenticatedClientUser.set(userInfo.getAuthorizedUserName());
                    AuthenticatedClientUser.setConnectionUser(userInfo.getConnectionUserName());
                    AuthenticatedClientUser.setAuthMethod(userInfo.getAuthMethod());
                } else {
                    AuthenticatedClientUser.remove();
                }
                callAuthenticated = true;
            }
            catch (UnauthenticatedException e) {
                String message = String.format("Channel: %s is not authenticated for call: %s", channelId.toString(), call.getMethodDescriptor().getFullMethodName());
                this.closeQuietly(call, Status.UNAUTHENTICATED.withDescription(message), headers);
            }
        } else {
            String message = String.format("Channel Id is missing for call: %s.", call.getMethodDescriptor().getFullMethodName());
            this.closeQuietly(call, Status.UNAUTHENTICATED.withDescription(message), headers);
        }
        return callAuthenticated;
    }

    private <ReqT, RespT> void closeQuietly(ServerCall<ReqT, RespT> call, Status status, Metadata headers) {
        try {
            LOG.debug("Closing the call:{} with Status:{}: {}", (Object)call.getMethodDescriptor().getFullMethodName(), (Object)status);
            call.close(status, headers);
        }
        catch (RuntimeException exc) {
            LOG.debug("Error while closing the call:{} with Status:{}: {}", new Object[]{call.getMethodDescriptor().getFullMethodName(), status, exc});
        }
    }
}

