/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.grpc.ChannelAuthenticationScheme;
import alluxio.grpc.GrpcChannelKey;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.SaslAuthenticationServiceGrpc;
import alluxio.grpc.SaslMessage;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedChannel;
import alluxio.security.authentication.ChannelIdInjector;
import alluxio.security.authentication.DefaultSaslHandshakeClientHandler;
import alluxio.security.authentication.SaslClientHandler;
import alluxio.security.authentication.SaslStreamClientDriver;
import alluxio.security.authentication.plain.SaslClientHandlerPlain;
import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ClientCall;
import alluxio.shaded.client.io.grpc.ClientInterceptors;
import alluxio.shaded.client.io.grpc.ConnectivityState;
import alluxio.shaded.client.io.grpc.ManagedChannel;
import alluxio.shaded.client.io.grpc.MethodDescriptor;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelAuthenticator.class);
    private AlluxioConfiguration mConfiguration;
    protected boolean mUseSubject;
    protected Subject mParentSubject;
    protected String mUserName;
    protected String mPassword;
    protected String mImpersonationUser;
    protected AuthType mAuthType;
    protected final long mGrpcAuthTimeoutMs;
    protected final GrpcChannelKey mChannelKey;

    public ChannelAuthenticator(GrpcChannelKey channelKey, Subject subject, AlluxioConfiguration conf) {
        this.mChannelKey = channelKey;
        this.mUseSubject = true;
        this.mParentSubject = subject;
        this.mConfiguration = conf;
        this.mAuthType = conf.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
        this.mGrpcAuthTimeoutMs = conf.getMs(PropertyKey.NETWORK_CONNECTION_AUTH_TIMEOUT);
    }

    public ChannelAuthenticator(GrpcChannelKey channelKey, String userName, String password, String impersonationUser, AuthType authType, long grpcAuthTimeoutMs) {
        this.mChannelKey = channelKey;
        this.mUseSubject = false;
        this.mUserName = userName;
        this.mPassword = password;
        this.mImpersonationUser = impersonationUser;
        this.mAuthType = authType;
        this.mGrpcAuthTimeoutMs = grpcAuthTimeoutMs;
    }

    public AuthenticatedChannel authenticate(ManagedChannel managedChannel) throws AlluxioStatusException {
        LOG.debug("Channel authentication initiated. ChannelKey:{}, AuthType:{}, Target:{}", new Object[]{this.mChannelKey, this.mAuthType, managedChannel.authority()});
        return new DefaultAuthenticatedChannel(managedChannel);
    }

    private class DefaultAuthenticatedChannel
    extends AuthenticatedChannel {
        private final ManagedChannel mManagedChannel;
        private Channel mChannel;
        private AtomicBoolean mAuthenticated;
        private SaslStreamClientDriver mClientDriver;

        DefaultAuthenticatedChannel(ManagedChannel managedChannel) throws AlluxioStatusException {
            this.mManagedChannel = managedChannel;
            this.mAuthenticated = new AtomicBoolean(false);
            this.authenticate();
        }

        public void authenticate() throws AlluxioStatusException {
            ChannelAuthenticationScheme authScheme = this.getChannelAuthScheme(ChannelAuthenticator.this.mParentSubject, ChannelAuthenticator.this.mChannelKey.getServerAddress().getSocketAddress());
            try (SaslClientHandler saslClientHandler = this.createSaslClientHandler(ChannelAuthenticator.this.mChannelKey.getServerAddress(), authScheme, ChannelAuthenticator.this.mParentSubject);){
                DefaultSaslHandshakeClientHandler handshakeClient = new DefaultSaslHandshakeClientHandler(saslClientHandler);
                this.mClientDriver = new SaslStreamClientDriver(handshakeClient, this.mAuthenticated, ChannelAuthenticator.this.mChannelKey, ChannelAuthenticator.this.mGrpcAuthTimeoutMs);
                StreamObserver<SaslMessage> requestObserver = SaslAuthenticationServiceGrpc.newStub(this.mManagedChannel).authenticate(this.mClientDriver);
                this.mClientDriver.setServerObserver(requestObserver);
                this.mClientDriver.start();
                this.mManagedChannel.notifyWhenStateChanged(ConnectivityState.READY, () -> this.mAuthenticated.set(false));
                this.mChannel = ClientInterceptors.intercept((Channel)this.mManagedChannel, new ChannelIdInjector(ChannelAuthenticator.this.mChannelKey.getChannelId()));
            }
            catch (IOException e) {
                Status.Code code = Status.Code.UNKNOWN;
                if (e instanceof AlluxioStatusException) {
                    code = ((AlluxioStatusException)e).getStatusCode();
                }
                String message = String.format("Channel authentication failed with code:%s. ChannelKey: %s, AuthType: %s, Error: %s", new Object[]{code.name(), ChannelAuthenticator.this.mChannelKey.toStringShort(), ChannelAuthenticator.this.mAuthType, e.toString()});
                throw AlluxioStatusException.from(Status.fromCode(code).withDescription(message).withCause(e));
            }
        }

        private ChannelAuthenticationScheme getChannelAuthScheme(Subject subject, SocketAddress serverAddress) throws UnauthenticatedException {
            switch (ChannelAuthenticator.this.mAuthType) {
                case NOSASL: {
                    return ChannelAuthenticationScheme.NOSASL;
                }
                case SIMPLE: {
                    return ChannelAuthenticationScheme.SIMPLE;
                }
                case CUSTOM: {
                    return ChannelAuthenticationScheme.CUSTOM;
                }
            }
            throw new UnauthenticatedException(String.format("Configured authentication type is not supported: %s", ChannelAuthenticator.this.mAuthType.getAuthName()));
        }

        private SaslClientHandler createSaslClientHandler(GrpcServerAddress serverAddress, ChannelAuthenticationScheme authScheme, Subject subject) throws UnauthenticatedException {
            switch (authScheme) {
                case SIMPLE: 
                case CUSTOM: {
                    if (ChannelAuthenticator.this.mUseSubject) {
                        return new SaslClientHandlerPlain(ChannelAuthenticator.this.mParentSubject, ChannelAuthenticator.this.mConfiguration);
                    }
                    return new SaslClientHandlerPlain(ChannelAuthenticator.this.mUserName, ChannelAuthenticator.this.mPassword, ChannelAuthenticator.this.mImpersonationUser);
                }
            }
            throw new UnauthenticatedException(String.format("Channel authentication scheme not supported: %s", authScheme.name()));
        }

        @Override
        public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
            return this.mChannel.newCall(methodDescriptor, callOptions);
        }

        @Override
        public String authority() {
            return this.mChannel.authority();
        }

        @Override
        public boolean isAuthenticated() {
            return this.mAuthenticated.get();
        }

        @Override
        public UUID getChannelId() {
            return ChannelAuthenticator.this.mChannelKey.getChannelId();
        }

        @Override
        public void close() {
            this.mClientDriver.stop();
        }
    }
}

