/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication.plain;

import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.grpc.ChannelAuthenticationScheme;
import alluxio.security.User;
import alluxio.security.authentication.AbstractSaslClientHandler;
import alluxio.security.authentication.AuthenticationUserUtils;
import alluxio.security.authentication.plain.PlainSaslClientCallbackHandler;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslClientHandlerPlain
extends AbstractSaslClientHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SaslClientHandlerPlain.class);

    public SaslClientHandlerPlain(Subject subject, AlluxioConfiguration conf) throws UnauthenticatedException {
        if (subject == null) {
            throw new UnauthenticatedException("client subject not provided");
        }
        String connectionUser = null;
        String password = "noPassword";
        Set<User> user = subject.getPrincipals(User.class);
        if (user != null && !user.isEmpty()) {
            connectionUser = user.iterator().next().getName();
        }
        String impersonationUser = AuthenticationUserUtils.getImpersonationUser(subject, conf);
        this.mSaslClient = this.createSaslClient(connectionUser, password, impersonationUser);
    }

    public SaslClientHandlerPlain(String username, String password, String impersonationUser) throws UnauthenticatedException {
        this.mSaslClient = this.createSaslClient(username, password, impersonationUser);
    }

    private SaslClient createSaslClient(String username, String password, String impersonationUser) throws UnauthenticatedException {
        try {
            return Sasl.createSaslClient(new String[]{"PLAIN"}, impersonationUser, null, null, new HashMap(), new PlainSaslClientCallbackHandler(username, password));
        }
        catch (SaslException e) {
            throw new UnauthenticatedException(e.getMessage(), e);
        }
    }

    @Override
    public ChannelAuthenticationScheme getClientScheme() {
        return ChannelAuthenticationScheme.SIMPLE;
    }
}

