/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block;

import alluxio.client.block.BlockMasterClient;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterClientContext;
import alluxio.resource.ResourcePool;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

@ThreadSafe
public final class BlockMasterClientPool
extends ResourcePool<BlockMasterClient> {
    private final MasterClientContext mMasterContext;
    private final Queue<BlockMasterClient> mClientList = new ConcurrentLinkedQueue<BlockMasterClient>();

    public BlockMasterClientPool(MasterClientContext ctx) {
        super(ctx.getClusterConf().getInt(PropertyKey.USER_BLOCK_MASTER_CLIENT_THREADS));
        this.mMasterContext = ctx;
    }

    @Override
    public void close() throws IOException {
        BlockMasterClient client;
        Closer closer = Closer.create();
        while ((client = this.mClientList.poll()) != null) {
            closer.register(client);
        }
        closer.close();
    }

    @Override
    protected BlockMasterClient createNewResource() {
        BlockMasterClient client = BlockMasterClient.Factory.create(this.mMasterContext);
        this.mClientList.add(client);
        return client;
    }
}

