/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.Client;
import alluxio.client.file.RetryHandlingFileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.CheckConsistencyPOptions;
import alluxio.grpc.CompleteFilePOptions;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.FreePOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.MountPOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.ScheduleAsyncPersistencePOptions;
import alluxio.grpc.SetAclAction;
import alluxio.grpc.SetAclPOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.grpc.UpdateUfsModePOptions;
import alluxio.master.MasterClientContext;
import alluxio.security.authorization.AclEntry;
import alluxio.wire.MountPointInfo;
import alluxio.wire.SyncPointInfo;
import java.util.List;
import java.util.Map;

public interface FileSystemMasterClient
extends Client {
    public List<AlluxioURI> checkConsistency(AlluxioURI var1, CheckConsistencyPOptions var2) throws AlluxioStatusException;

    public void createDirectory(AlluxioURI var1, CreateDirectoryPOptions var2) throws AlluxioStatusException;

    public URIStatus createFile(AlluxioURI var1, CreateFilePOptions var2) throws AlluxioStatusException;

    public void completeFile(AlluxioURI var1, CompleteFilePOptions var2) throws AlluxioStatusException;

    public void delete(AlluxioURI var1, DeletePOptions var2) throws AlluxioStatusException;

    public void free(AlluxioURI var1, FreePOptions var2) throws AlluxioStatusException;

    public String getFilePath(long var1) throws AlluxioStatusException;

    public URIStatus getStatus(AlluxioURI var1, GetStatusPOptions var2) throws AlluxioStatusException;

    public long getNewBlockIdForFile(AlluxioURI var1) throws AlluxioStatusException;

    public List<SyncPointInfo> getSyncPathList() throws AlluxioStatusException;

    public List<URIStatus> listStatus(AlluxioURI var1, ListStatusPOptions var2) throws AlluxioStatusException;

    public void mount(AlluxioURI var1, AlluxioURI var2, MountPOptions var3) throws AlluxioStatusException;

    public void updateMount(AlluxioURI var1, MountPOptions var2) throws AlluxioStatusException;

    public Map<String, MountPointInfo> getMountTable() throws AlluxioStatusException;

    public void rename(AlluxioURI var1, AlluxioURI var2) throws AlluxioStatusException;

    public void rename(AlluxioURI var1, AlluxioURI var2, RenamePOptions var3) throws AlluxioStatusException;

    public AlluxioURI reverseResolve(AlluxioURI var1) throws AlluxioStatusException;

    public void setAcl(AlluxioURI var1, SetAclAction var2, List<AclEntry> var3, SetAclPOptions var4) throws AlluxioStatusException;

    public void setAttribute(AlluxioURI var1, SetAttributePOptions var2) throws AlluxioStatusException;

    public void startSync(AlluxioURI var1) throws AlluxioStatusException;

    public void stopSync(AlluxioURI var1) throws AlluxioStatusException;

    public void scheduleAsyncPersist(AlluxioURI var1, ScheduleAsyncPersistencePOptions var2) throws AlluxioStatusException;

    public void unmount(AlluxioURI var1) throws AlluxioStatusException;

    public void updateUfsMode(AlluxioURI var1, UpdateUfsModePOptions var2) throws AlluxioStatusException;

    public static class Factory {
        private Factory() {
        }

        public static FileSystemMasterClient create(MasterClientContext conf) {
            return new RetryHandlingFileSystemMasterClient(conf);
        }
    }
}

