/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.options;

import alluxio.ClientContext;
import alluxio.client.AlluxioStorageType;
import alluxio.client.UnderStorageType;
import alluxio.client.WriteType;
import alluxio.client.block.policy.BlockLocationPolicy;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.Mode;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.CommonUtils;
import alluxio.util.FileSystemOptions;
import alluxio.util.ModeUtils;
import java.io.IOException;

@NotThreadSafe
public final class OutStreamOptions {
    private FileSystemMasterCommonPOptions mCommonOptions;
    private long mBlockSizeBytes;
    private BlockLocationPolicy mLocationPolicy;
    private int mWriteTier;
    private WriteType mWriteType;
    private String mOwner;
    private String mGroup;
    private Mode mMode;
    private AccessControlList mAcl;
    private long mPersistenceWaitTime;
    private int mReplicationDurable;
    private int mReplicationMax;
    private int mReplicationMin;
    private String mUfsPath;
    private long mMountId;
    private String mMediumType;

    public static OutStreamOptions defaults(ClientContext context, AlluxioConfiguration alluxioConf) {
        return new OutStreamOptions(context, alluxioConf);
    }

    public static OutStreamOptions defaults(ClientContext context) {
        return new OutStreamOptions(context, context.getClusterConf());
    }

    public OutStreamOptions(CreateFilePOptions options, ClientContext context, AlluxioConfiguration alluxioConf) {
        this(context, alluxioConf);
        if (options.hasCommonOptions()) {
            this.mCommonOptions = this.mCommonOptions.toBuilder().mergeFrom(options.getCommonOptions()).build();
        }
        if (options.hasBlockSizeBytes()) {
            this.mBlockSizeBytes = options.getBlockSizeBytes();
        }
        if (options.hasMode()) {
            this.mMode = Mode.fromProto(options.getMode());
        }
        if (options.hasPersistenceWaitTime()) {
            this.mPersistenceWaitTime = options.getPersistenceWaitTime();
        }
        if (options.hasReplicationDurable()) {
            this.mReplicationDurable = options.getReplicationDurable();
        }
        if (options.hasReplicationMin()) {
            this.mReplicationMin = options.getReplicationMin();
        }
        if (options.hasReplicationMax()) {
            this.mReplicationMax = options.getReplicationMax();
        }
        if (options.hasWriteTier()) {
            this.mWriteTier = options.getWriteTier();
        }
        if (options.hasWriteType()) {
            this.mWriteType = WriteType.fromProto(options.getWriteType());
        }
        try {
            this.mLocationPolicy = BlockLocationPolicy.Factory.create(alluxioConf.get(PropertyKey.USER_BLOCK_WRITE_LOCATION_POLICY), alluxioConf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private OutStreamOptions(ClientContext context, AlluxioConfiguration alluxioConf) {
        this.mCommonOptions = FileSystemOptions.commonDefaults(alluxioConf);
        this.mBlockSizeBytes = alluxioConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
        this.mLocationPolicy = BlockLocationPolicy.Factory.create(alluxioConf.get(PropertyKey.USER_BLOCK_WRITE_LOCATION_POLICY), alluxioConf);
        this.mWriteTier = alluxioConf.getInt(PropertyKey.USER_FILE_WRITE_TIER_DEFAULT);
        this.mWriteType = alluxioConf.getEnum(PropertyKey.USER_FILE_WRITE_TYPE_DEFAULT, WriteType.class);
        try {
            this.mOwner = context.getUserState().getUser().getName();
            this.mGroup = CommonUtils.getPrimaryGroupName(this.mOwner, context.getClusterConf());
        }
        catch (IOException e) {
            this.mOwner = "";
            this.mGroup = "";
        }
        this.mMode = ModeUtils.applyFileUMask(Mode.defaults(), alluxioConf.get(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK));
        this.mMountId = -1L;
        this.mPersistenceWaitTime = alluxioConf.getMs(PropertyKey.USER_FILE_PERSISTENCE_INITIAL_WAIT_TIME);
        this.mReplicationDurable = alluxioConf.getInt(PropertyKey.USER_FILE_REPLICATION_DURABLE);
        this.mReplicationMax = alluxioConf.getInt(PropertyKey.USER_FILE_REPLICATION_MAX);
        this.mReplicationMin = alluxioConf.getInt(PropertyKey.USER_FILE_REPLICATION_MIN);
        this.mMediumType = "";
    }

    public String getMediumType() {
        return this.mMediumType;
    }

    public AccessControlList getAcl() {
        return this.mAcl;
    }

    public long getBlockSizeBytes() {
        return this.mBlockSizeBytes;
    }

    public BlockLocationPolicy getLocationPolicy() {
        return this.mLocationPolicy;
    }

    public AlluxioStorageType getAlluxioStorageType() {
        return this.mWriteType.getAlluxioStorageType();
    }

    public FileSystemMasterCommonPOptions getCommonOptions() {
        return this.mCommonOptions;
    }

    public UnderStorageType getUnderStorageType() {
        return this.mWriteType.getUnderStorageType();
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public Mode getMode() {
        return this.mMode;
    }

    public long getPersistenceWaitTime() {
        return this.mPersistenceWaitTime;
    }

    public int getReplicationDurable() {
        return this.mReplicationDurable;
    }

    public int getReplicationMax() {
        return this.mReplicationMax;
    }

    public int getReplicationMin() {
        return this.mReplicationMin;
    }

    public long getMountId() {
        return this.mMountId;
    }

    public String getUfsPath() {
        return this.mUfsPath;
    }

    public int getWriteTier() {
        return this.mWriteTier;
    }

    public WriteType getWriteType() {
        return this.mWriteType;
    }

    public OutStreamOptions setMediumType(String mediumType) {
        this.mMediumType = mediumType;
        return this;
    }

    public OutStreamOptions setAcl(AccessControlList acl) {
        this.mAcl = acl;
        return this;
    }

    public OutStreamOptions setBlockSizeBytes(long blockSizeBytes) {
        this.mBlockSizeBytes = blockSizeBytes;
        return this;
    }

    public OutStreamOptions setLocationPolicy(BlockLocationPolicy locationPolicy) {
        this.mLocationPolicy = locationPolicy;
        return this;
    }

    public OutStreamOptions setWriteTier(int writeTier) {
        this.mWriteTier = writeTier;
        return this;
    }

    public OutStreamOptions setWriteType(WriteType writeType) {
        this.mWriteType = writeType;
        return this;
    }

    public OutStreamOptions setMountId(long mountId) {
        this.mMountId = mountId;
        return this;
    }

    public OutStreamOptions setUfsPath(String ufsPath) {
        this.mUfsPath = ufsPath;
        return this;
    }

    public OutStreamOptions setOwner(String owner) {
        this.mOwner = owner;
        return this;
    }

    public OutStreamOptions setGroup(String group) {
        this.mGroup = group;
        return this;
    }

    public OutStreamOptions setPersistenceWaitTime(long persistenceWaitTime) {
        this.mPersistenceWaitTime = persistenceWaitTime;
        return this;
    }

    public OutStreamOptions setReplicationDurable(int replicationDurable) {
        this.mReplicationDurable = replicationDurable;
        return this;
    }

    public OutStreamOptions setReplicationMax(int replicationMax) {
        this.mReplicationMax = replicationMax;
        return this;
    }

    public OutStreamOptions setReplicationMin(int replicationMin) {
        this.mReplicationMin = replicationMin;
        return this;
    }

    public OutStreamOptions setMode(Mode mode) {
        this.mMode = mode;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OutStreamOptions)) {
            return false;
        }
        OutStreamOptions that = (OutStreamOptions)o;
        return Objects.equal(this.mAcl, that.mAcl) && Objects.equal(this.mBlockSizeBytes, that.mBlockSizeBytes) && Objects.equal(this.mCommonOptions, that.mCommonOptions) && Objects.equal(this.mGroup, that.mGroup) && Objects.equal(this.mLocationPolicy, that.mLocationPolicy) && Objects.equal(this.mMediumType, that.mMediumType) && Objects.equal(this.mMode, that.mMode) && Objects.equal(this.mMountId, that.mMountId) && Objects.equal(this.mOwner, that.mOwner) && Objects.equal(this.mPersistenceWaitTime, that.mPersistenceWaitTime) && Objects.equal(this.mReplicationDurable, that.mReplicationDurable) && Objects.equal(this.mReplicationMax, that.mReplicationMax) && Objects.equal(this.mReplicationMin, that.mReplicationMin) && Objects.equal(this.mUfsPath, that.mUfsPath) && Objects.equal(this.mWriteTier, that.mWriteTier) && Objects.equal((Object)this.mWriteType, (Object)that.mWriteType);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.mAcl, this.mBlockSizeBytes, this.mCommonOptions, this.mGroup, this.mLocationPolicy, this.mMediumType, this.mMode, this.mMountId, this.mOwner, this.mPersistenceWaitTime, this.mReplicationDurable, this.mReplicationMax, this.mReplicationMin, this.mUfsPath, this.mWriteTier, this.mWriteType});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("acl", this.mAcl).add("blockSizeBytes", this.mBlockSizeBytes).add("commonOptions", this.mCommonOptions).add("group", this.mGroup).add("locationPolicy", this.mLocationPolicy).add("mediumType", this.mMediumType).add("mode", this.mMode).add("mountId", this.mMountId).add("owner", this.mOwner).add("ufsPath", this.mUfsPath).add("writeTier", this.mWriteTier).add("writeType", (Object)this.mWriteType).add("persistenceWaitTime", this.mPersistenceWaitTime).add("replicationDurable", this.mReplicationDurable).add("replicationMax", this.mReplicationMax).add("replicationMin", this.mReplicationMin).toString();
    }
}

