/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.journal;

import alluxio.AbstractMasterClient;
import alluxio.client.journal.JournalMasterClient;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.GetQuorumInfoPRequest;
import alluxio.grpc.GetQuorumInfoPResponse;
import alluxio.grpc.JournalMasterClientServiceGrpc;
import alluxio.grpc.NetAddress;
import alluxio.grpc.RemoveQuorumServerPRequest;
import alluxio.grpc.ServiceType;
import alluxio.master.MasterClientContext;

public class RetryHandlingJournalMasterClient
extends AbstractMasterClient
implements JournalMasterClient {
    private JournalMasterClientServiceGrpc.JournalMasterClientServiceBlockingStub mClient = null;

    public RetryHandlingJournalMasterClient(MasterClientContext conf) {
        super(conf);
    }

    @Override
    protected ServiceType getRemoteServiceType() {
        return ServiceType.JOURNAL_MASTER_CLIENT_SERVICE;
    }

    @Override
    protected String getServiceName() {
        return "JournalMaster";
    }

    @Override
    protected long getServiceVersion() {
        return 1L;
    }

    @Override
    protected void afterConnect() {
        this.mClient = JournalMasterClientServiceGrpc.newBlockingStub(this.mChannel);
    }

    @Override
    public GetQuorumInfoPResponse getQuorumInfo() throws AlluxioStatusException {
        return this.retryRPC(() -> this.mClient.getQuorumInfo(GetQuorumInfoPRequest.getDefaultInstance()));
    }

    @Override
    public void removeQuorumServer(NetAddress serverAddress) throws AlluxioStatusException {
        this.retryRPC(() -> this.mClient.removeQuorumServer(RemoveQuorumServerPRequest.newBuilder().setServerAddress(serverAddress).build()));
    }
}

