/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.meta;

import alluxio.AbstractMasterClient;
import alluxio.AlluxioURI;
import alluxio.client.meta.MetaMasterConfigClient;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GetConfigHashPOptions;
import alluxio.grpc.GetConfigurationPOptions;
import alluxio.grpc.MetaMasterConfigurationServiceGrpc;
import alluxio.grpc.RemovePathConfigurationPRequest;
import alluxio.grpc.ServiceType;
import alluxio.grpc.SetPathConfigurationPRequest;
import alluxio.master.MasterClientContext;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.wire.ConfigHash;
import alluxio.wire.Configuration;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@ThreadSafe
public class RetryHandlingMetaMasterConfigClient
extends AbstractMasterClient
implements MetaMasterConfigClient {
    private MetaMasterConfigurationServiceGrpc.MetaMasterConfigurationServiceBlockingStub mClient = null;

    public RetryHandlingMetaMasterConfigClient(MasterClientContext conf) {
        super(conf);
    }

    @Override
    protected ServiceType getRemoteServiceType() {
        return ServiceType.META_MASTER_CONFIG_SERVICE;
    }

    @Override
    protected String getServiceName() {
        return "MetaMaster";
    }

    @Override
    protected long getServiceVersion() {
        return 2L;
    }

    @Override
    protected void afterConnect() {
        this.mClient = MetaMasterConfigurationServiceGrpc.newBlockingStub(this.mChannel);
    }

    @Override
    public Configuration getConfiguration(GetConfigurationPOptions options) throws IOException {
        return Configuration.fromProto(this.retryRPC(() -> this.mClient.getConfiguration(options)));
    }

    @Override
    public ConfigHash getConfigHash() throws IOException {
        return ConfigHash.fromProto(this.retryRPC(() -> this.mClient.getConfigHash(GetConfigHashPOptions.getDefaultInstance())));
    }

    @Override
    public void setPathConfiguration(AlluxioURI path, Map<PropertyKey, String> properties) throws IOException {
        HashMap props = new HashMap();
        properties.forEach((key, value) -> props.put(key.getName(), value));
        this.retryRPC(() -> this.mClient.setPathConfiguration(SetPathConfigurationPRequest.newBuilder().setPath(path.getPath()).putAllProperties(props).build()));
    }

    @Override
    public void removePathConfiguration(AlluxioURI path, Set<PropertyKey> keys) throws IOException {
        HashSet<String> keySet = new HashSet<String>();
        for (PropertyKey key : keys) {
            keySet.add(key.getName());
        }
        this.retryRPC(() -> this.mClient.removePathConfiguration(RemovePathConfigurationPRequest.newBuilder().setPath(path.getPath()).addAllKeys(keySet).build()));
    }

    @Override
    public void removePathConfiguration(AlluxioURI path) throws IOException {
        this.retryRPC(() -> this.mClient.removePathConfiguration(RemovePathConfigurationPRequest.newBuilder().setPath(path.getPath()).build()));
    }
}

