/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import alluxio.shaded.client.javax.annotation.Nullable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class TwoKeyConcurrentMap<K1, K2, V, M extends Map<K2, V>>
extends ConcurrentHashMap<K1, M> {
    private static final long serialVersionUID = 0L;
    private final Supplier<M> mInnerMapFn;

    public TwoKeyConcurrentMap(Supplier<M> innerMapCreator) {
        this.mInnerMapFn = innerMapCreator;
    }

    public void addInnerValue(K1 k1, K2 k2, V v) {
        this.compute(k1, (k, inner) -> {
            if (inner == null) {
                inner = (Map)this.mInnerMapFn.get();
            }
            inner.put(k2, v);
            return inner;
        });
    }

    @Nullable
    public void removeInnerValue(K1 k1, K2 k2) {
        this.computeIfPresent(k1, (k, inner) -> {
            inner.remove(k2);
            if (inner.isEmpty()) {
                return null;
            }
            return inner;
        });
    }

    public <R> Set<R> flattenEntries(TriFunction<K1, K2, V, R> fn) {
        return this.entrySet().stream().flatMap(outer -> ((Map)outer.getValue()).entrySet().stream().map(inner -> fn.apply(outer.getKey(), inner.getKey(), inner.getValue()))).collect(Collectors.toSet());
    }

    @FunctionalInterface
    public static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

