/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.org.apache.commons.lang.builder.HashCodeBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;

public class GrpcServerAddress {
    private SocketAddress mSocketAddress;
    private String mHostName;

    private GrpcServerAddress(String hostName, SocketAddress socketAddress) {
        this.mHostName = hostName;
        this.mSocketAddress = socketAddress;
    }

    public static GrpcServerAddress create(InetSocketAddress socketAddress) {
        return new GrpcServerAddress(socketAddress.getHostName(), socketAddress);
    }

    public static GrpcServerAddress create(String hostName, SocketAddress socketAddress) {
        return new GrpcServerAddress(hostName, socketAddress);
    }

    public String getHostName() {
        return this.mHostName;
    }

    public SocketAddress getSocketAddress() {
        return this.mSocketAddress;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.mHostName).append(this.mSocketAddress).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GrpcServerAddress)) {
            return false;
        }
        GrpcServerAddress otherAddress = (GrpcServerAddress)other;
        return Objects.equals(this.mHostName, otherAddress.getHostName()) && Objects.equals(this.mSocketAddress, otherAddress.getSocketAddress());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("HostName", this.mHostName).add("SocketAddress", this.mSocketAddress).toString();
    }
}

