/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class HadoopConfigurationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopConfigurationUtils.class);

    private HadoopConfigurationUtils() {
    }

    public static InstancedConfiguration mergeHadoopConfiguration(Configuration hadoopConf, AlluxioProperties alluxioProps) {
        Properties alluxioConfProperties = new Properties();
        for (Map.Entry entry : hadoopConf) {
            String propertyName = (String)entry.getKey();
            if (!PropertyKey.isValid(propertyName)) continue;
            alluxioConfProperties.put(propertyName, entry.getValue());
        }
        LOG.info("Loading Alluxio properties from Hadoop configuration: {}", (Object)alluxioConfProperties);
        alluxioProps.merge(alluxioConfProperties, Source.RUNTIME);
        InstancedConfiguration mergedConf = new InstancedConfiguration(alluxioProps);
        mergedConf.validate();
        return mergedConf;
    }

    public static Configuration mergeAlluxioConfiguration(Configuration source, AlluxioConfiguration alluxioConf) {
        Configuration mergedConf = new Configuration();
        source.forEach(e -> mergedConf.set((String)e.getKey(), (String)e.getValue()));
        alluxioConf.copyProperties().forEach((pk, val) -> {
            if (val != null) {
                mergedConf.set(pk.getName(), val);
            }
        });
        return mergedConf;
    }
}

