/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.exception.status.UnauthenticatedException;
import alluxio.grpc.SaslMessage;
import alluxio.grpc.SaslMessageType;
import alluxio.security.authentication.SaslClientHandler;
import alluxio.security.authentication.SaslHandshakeClientHandler;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.protobuf.ByteString;
import java.util.UUID;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class DefaultSaslHandshakeClientHandler
implements SaslHandshakeClientHandler {
    private static final byte[] S_INITIATE_CHALLENGE = new byte[0];
    private final SaslClientHandler mSaslClientHandler;
    private final SaslClient mSaslClient;

    public DefaultSaslHandshakeClientHandler(SaslClientHandler saslClientHandler) throws UnauthenticatedException {
        this.mSaslClientHandler = saslClientHandler;
        this.mSaslClient = this.mSaslClientHandler.getSaslClient();
    }

    @Override
    public SaslMessage handleSaslMessage(SaslMessage message) throws SaslException {
        switch (message.getMessageType()) {
            case CHALLENGE: {
                byte[] saslResponse = this.mSaslClient.evaluateChallenge(message.getMessage().toByteArray());
                SaslMessage.Builder response = SaslMessage.newBuilder().setMessageType(SaslMessageType.CHALLENGE);
                if (saslResponse != null) {
                    response.setMessage(ByteString.copyFrom(saslResponse));
                }
                return response.build();
            }
            case SUCCESS: {
                if (message.hasMessage()) {
                    this.mSaslClient.evaluateChallenge(message.getMessage().toByteArray());
                }
                Preconditions.checkArgument(this.mSaslClient.isComplete());
                return null;
            }
        }
        throw new SaslException("Client can't process Sasl message type:" + message.getMessageType().name());
    }

    @Override
    public SaslMessage getInitialMessage(UUID channelId) throws SaslException {
        byte[] initiateSaslResponse = null;
        if (this.mSaslClientHandler.getSaslClient().hasInitialResponse()) {
            initiateSaslResponse = this.mSaslClient.evaluateChallenge(S_INITIATE_CHALLENGE);
        }
        SaslMessage.Builder initialResponse = SaslMessage.newBuilder().setMessageType(SaslMessageType.CHALLENGE).setAuthenticationScheme(this.mSaslClientHandler.getClientScheme());
        if (initiateSaslResponse != null) {
            initialResponse.setMessage(ByteString.copyFrom(initiateSaslResponse));
        }
        initialResponse.setClientId(channelId.toString());
        return initialResponse.build();
    }
}

