/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.grpc;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.io.grpc.ExperimentalApi;
import alluxio.shaded.client.javax.annotation.concurrent.GuardedBy;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@ThreadSafe
@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4984")
public final class SynchronizationContext
implements Executor {
    private final Object lock = new Object();
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    @GuardedBy(value="lock")
    private final Queue<Runnable> queue = new ArrayDeque<Runnable>();
    @GuardedBy(value="lock")
    private Thread drainingThread;

    public SynchronizationContext(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = Preconditions.checkNotNull(uncaughtExceptionHandler, "uncaughtExceptionHandler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drain() {
        boolean drainLeaseAcquired = false;
        while (true) {
            Runnable runnable;
            Object object = this.lock;
            synchronized (object) {
                if (!drainLeaseAcquired) {
                    if (this.drainingThread != null) {
                        return;
                    }
                    this.drainingThread = Thread.currentThread();
                    drainLeaseAcquired = true;
                }
                if ((runnable = this.queue.poll()) == null) {
                    this.drainingThread = null;
                    break;
                }
            }
            try {
                runnable.run();
            }
            catch (Throwable t) {
                this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeLater(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(Preconditions.checkNotNull(runnable, "runnable is null"));
        }
    }

    @Override
    public final void execute(Runnable task) {
        this.executeLater(task);
        this.drain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwIfNotInThisSynchronizationContext() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState(Thread.currentThread() == this.drainingThread, "Not called from the SynchronizationContext");
        }
    }

    public final ScheduledHandle schedule(final Runnable task, long delay, TimeUnit unit, ScheduledExecutorService timerService) {
        final ManagedRunnable runnable = new ManagedRunnable(task);
        ScheduledFuture<?> future = timerService.schedule(new Runnable(){

            @Override
            public void run() {
                SynchronizationContext.this.execute(runnable);
            }

            public String toString() {
                return task.toString() + "(scheduled in SynchronizationContext)";
            }
        }, delay, unit);
        return new ScheduledHandle(runnable, future);
    }

    public static final class ScheduledHandle {
        private final ManagedRunnable runnable;
        private final ScheduledFuture<?> future;

        private ScheduledHandle(ManagedRunnable runnable, ScheduledFuture<?> future) {
            this.runnable = Preconditions.checkNotNull(runnable, "runnable");
            this.future = Preconditions.checkNotNull(future, "future");
        }

        public void cancel() {
            this.runnable.isCancelled = true;
            this.future.cancel(false);
        }

        public boolean isPending() {
            return !this.runnable.hasStarted && !this.runnable.isCancelled;
        }
    }

    private static class ManagedRunnable
    implements Runnable {
        final Runnable task;
        boolean isCancelled;
        boolean hasStarted;

        ManagedRunnable(Runnable task) {
            this.task = Preconditions.checkNotNull(task, "task");
        }

        @Override
        public void run() {
            if (!this.isCancelled) {
                this.hasStarted = true;
                this.task.run();
            }
        }
    }
}

