/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.opencensus.common;

import alluxio.shaded.client.io.opencensus.common.AutoValue_Duration;
import alluxio.shaded.client.io.opencensus.common.TimeUtils;
import alluxio.shaded.client.javax.annotation.concurrent.Immutable;
import java.util.concurrent.TimeUnit;

@Immutable
public abstract class Duration
implements Comparable<Duration> {
    public static Duration create(long seconds, int nanos) {
        if (seconds < -315576000000L) {
            throw new IllegalArgumentException("'seconds' is less than minimum (-315576000000): " + seconds);
        }
        if (seconds > 315576000000L) {
            throw new IllegalArgumentException("'seconds' is greater than maximum (315576000000): " + seconds);
        }
        if (nanos < -999999999) {
            throw new IllegalArgumentException("'nanos' is less than minimum (-999999999): " + nanos);
        }
        if (nanos > 999999999) {
            throw new IllegalArgumentException("'nanos' is greater than maximum (999999999): " + nanos);
        }
        if (seconds < 0L && nanos > 0 || seconds > 0L && nanos < 0) {
            throw new IllegalArgumentException("'seconds' and 'nanos' have inconsistent sign: seconds=" + seconds + ", nanos=" + nanos);
        }
        return new AutoValue_Duration(seconds, nanos);
    }

    public static Duration fromMillis(long millis) {
        long seconds = millis / 1000L;
        int nanos = (int)(millis % 1000L * 1000000L);
        return Duration.create(seconds, nanos);
    }

    public long toMillis() {
        return TimeUnit.SECONDS.toMillis(this.getSeconds()) + TimeUnit.NANOSECONDS.toMillis(this.getNanos());
    }

    public abstract long getSeconds();

    public abstract int getNanos();

    @Override
    public int compareTo(Duration otherDuration) {
        int cmp = TimeUtils.compareLongs(this.getSeconds(), otherDuration.getSeconds());
        if (cmp != 0) {
            return cmp;
        }
        return TimeUtils.compareLongs(this.getNanos(), otherDuration.getNanos());
    }

    Duration() {
    }
}

