/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.opencensus.trace;

import alluxio.shaded.client.com.google.errorprone.annotations.MustBeClosed;
import alluxio.shaded.client.io.opencensus.common.Scope;
import alluxio.shaded.client.io.opencensus.internal.Utils;
import alluxio.shaded.client.io.opencensus.trace.BlankSpan;
import alluxio.shaded.client.io.opencensus.trace.CurrentSpanUtils;
import alluxio.shaded.client.io.opencensus.trace.Span;
import alluxio.shaded.client.io.opencensus.trace.SpanBuilder;
import alluxio.shaded.client.io.opencensus.trace.SpanContext;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.util.concurrent.Callable;

public abstract class Tracer {
    private static final NoopTracer noopTracer = new NoopTracer();

    static Tracer getNoopTracer() {
        return noopTracer;
    }

    public final Span getCurrentSpan() {
        Span currentSpan = CurrentSpanUtils.getCurrentSpan();
        return currentSpan != null ? currentSpan : BlankSpan.INSTANCE;
    }

    @MustBeClosed
    public final Scope withSpan(Span span) {
        return CurrentSpanUtils.withSpan(Utils.checkNotNull(span, "span"), false);
    }

    public final Runnable withSpan(Span span, Runnable runnable) {
        return CurrentSpanUtils.withSpan(span, false, runnable);
    }

    public final <C> Callable<C> withSpan(Span span, Callable<C> callable) {
        return CurrentSpanUtils.withSpan(span, false, callable);
    }

    public final SpanBuilder spanBuilder(String spanName) {
        return this.spanBuilderWithExplicitParent(spanName, CurrentSpanUtils.getCurrentSpan());
    }

    public abstract SpanBuilder spanBuilderWithExplicitParent(String var1, @Nullable Span var2);

    public abstract SpanBuilder spanBuilderWithRemoteParent(String var1, @Nullable SpanContext var2);

    protected Tracer() {
    }

    private static final class NoopTracer
    extends Tracer {
        @Override
        public SpanBuilder spanBuilderWithExplicitParent(String spanName, @Nullable Span parent) {
            return SpanBuilder.NoopSpanBuilder.createWithParent(spanName, parent);
        }

        @Override
        public SpanBuilder spanBuilderWithRemoteParent(String spanName, @Nullable SpanContext remoteParentSpanContext) {
            return SpanBuilder.NoopSpanBuilder.createWithRemoteParent(spanName, remoteParentSpanContext);
        }

        private NoopTracer() {
        }
    }
}

