package alluxio.grpc;

import static alluxio.shaded.client.io.grpc.MethodDescriptor.generateFullMethodName;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 **
 * This interface contains file system master service endpoints for Alluxio workers.
 * </pre>
 */
@alluxio.shaded.client.javax.annotation.Generated(
    value = "by gRPC proto alluxio.shaded.client.com.iler (version 1.17.1)",
    alluxio.shaded.client.com.ents = "Source: grpc/file_system_master.proto")
public final class FileSystemMasterWorkerServiceGrpc {

  private FileSystemMasterWorkerServiceGrpc() {}

  public static final String SERVICE_NAME = "alluxio.grpc.file.FileSystemMasterWorkerService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.FileSystemHeartbeatPRequest,
      alluxio.grpc.FileSystemHeartbeatPResponse> getFileSystemHeartbeatMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "FileSystemHeartbeat",
      requestType = alluxio.grpc.FileSystemHeartbeatPRequest.class,
      responseType = alluxio.grpc.FileSystemHeartbeatPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.FileSystemHeartbeatPRequest,
      alluxio.grpc.FileSystemHeartbeatPResponse> getFileSystemHeartbeatMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.FileSystemHeartbeatPRequest, alluxio.grpc.FileSystemHeartbeatPResponse> getFileSystemHeartbeatMethod;
    if ((getFileSystemHeartbeatMethod = FileSystemMasterWorkerServiceGrpc.getFileSystemHeartbeatMethod) == null) {
      synchronized (FileSystemMasterWorkerServiceGrpc.class) {
        if ((getFileSystemHeartbeatMethod = FileSystemMasterWorkerServiceGrpc.getFileSystemHeartbeatMethod) == null) {
          FileSystemMasterWorkerServiceGrpc.getFileSystemHeartbeatMethod = getFileSystemHeartbeatMethod = 
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.FileSystemHeartbeatPRequest, alluxio.grpc.FileSystemHeartbeatPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "alluxio.grpc.file.FileSystemMasterWorkerService", "FileSystemHeartbeat"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.FileSystemHeartbeatPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.FileSystemHeartbeatPResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new FileSystemMasterWorkerServiceMethodDescriptorSupplier("FileSystemHeartbeat"))
                  .build();
          }
        }
     }
     return getFileSystemHeartbeatMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetFileInfoPRequest,
      alluxio.grpc.GetFileInfoPResponse> getGetFileInfoMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetFileInfo",
      requestType = alluxio.grpc.GetFileInfoPRequest.class,
      responseType = alluxio.grpc.GetFileInfoPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetFileInfoPRequest,
      alluxio.grpc.GetFileInfoPResponse> getGetFileInfoMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetFileInfoPRequest, alluxio.grpc.GetFileInfoPResponse> getGetFileInfoMethod;
    if ((getGetFileInfoMethod = FileSystemMasterWorkerServiceGrpc.getGetFileInfoMethod) == null) {
      synchronized (FileSystemMasterWorkerServiceGrpc.class) {
        if ((getGetFileInfoMethod = FileSystemMasterWorkerServiceGrpc.getGetFileInfoMethod) == null) {
          FileSystemMasterWorkerServiceGrpc.getGetFileInfoMethod = getGetFileInfoMethod = 
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetFileInfoPRequest, alluxio.grpc.GetFileInfoPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "alluxio.grpc.file.FileSystemMasterWorkerService", "GetFileInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetFileInfoPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetFileInfoPResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new FileSystemMasterWorkerServiceMethodDescriptorSupplier("GetFileInfo"))
                  .build();
          }
        }
     }
     return getGetFileInfoMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetPinnedFileIdsPRequest,
      alluxio.grpc.GetPinnedFileIdsPResponse> getGetPinnedFileIdsMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetPinnedFileIds",
      requestType = alluxio.grpc.GetPinnedFileIdsPRequest.class,
      responseType = alluxio.grpc.GetPinnedFileIdsPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetPinnedFileIdsPRequest,
      alluxio.grpc.GetPinnedFileIdsPResponse> getGetPinnedFileIdsMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetPinnedFileIdsPRequest, alluxio.grpc.GetPinnedFileIdsPResponse> getGetPinnedFileIdsMethod;
    if ((getGetPinnedFileIdsMethod = FileSystemMasterWorkerServiceGrpc.getGetPinnedFileIdsMethod) == null) {
      synchronized (FileSystemMasterWorkerServiceGrpc.class) {
        if ((getGetPinnedFileIdsMethod = FileSystemMasterWorkerServiceGrpc.getGetPinnedFileIdsMethod) == null) {
          FileSystemMasterWorkerServiceGrpc.getGetPinnedFileIdsMethod = getGetPinnedFileIdsMethod = 
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetPinnedFileIdsPRequest, alluxio.grpc.GetPinnedFileIdsPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "alluxio.grpc.file.FileSystemMasterWorkerService", "GetPinnedFileIds"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetPinnedFileIdsPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetPinnedFileIdsPResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new FileSystemMasterWorkerServiceMethodDescriptorSupplier("GetPinnedFileIds"))
                  .build();
          }
        }
     }
     return getGetPinnedFileIdsMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetUfsInfoPRequest,
      alluxio.grpc.GetUfsInfoPResponse> getGetUfsInfoMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetUfsInfo",
      requestType = alluxio.grpc.GetUfsInfoPRequest.class,
      responseType = alluxio.grpc.GetUfsInfoPResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetUfsInfoPRequest,
      alluxio.grpc.GetUfsInfoPResponse> getGetUfsInfoMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.grpc.GetUfsInfoPRequest, alluxio.grpc.GetUfsInfoPResponse> getGetUfsInfoMethod;
    if ((getGetUfsInfoMethod = FileSystemMasterWorkerServiceGrpc.getGetUfsInfoMethod) == null) {
      synchronized (FileSystemMasterWorkerServiceGrpc.class) {
        if ((getGetUfsInfoMethod = FileSystemMasterWorkerServiceGrpc.getGetUfsInfoMethod) == null) {
          FileSystemMasterWorkerServiceGrpc.getGetUfsInfoMethod = getGetUfsInfoMethod = 
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.grpc.GetUfsInfoPRequest, alluxio.grpc.GetUfsInfoPResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "alluxio.grpc.file.FileSystemMasterWorkerService", "GetUfsInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetUfsInfoPRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.grpc.GetUfsInfoPResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new FileSystemMasterWorkerServiceMethodDescriptorSupplier("GetUfsInfo"))
                  .build();
          }
        }
     }
     return getGetUfsInfoMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static FileSystemMasterWorkerServiceStub newStub(alluxio.shaded.client.io.grpc.Channel channel) {
    return new FileSystemMasterWorkerServiceStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static FileSystemMasterWorkerServiceBlockingStub newBlockingStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    return new FileSystemMasterWorkerServiceBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static FileSystemMasterWorkerServiceFutureStub newFutureStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    return new FileSystemMasterWorkerServiceFutureStub(channel);
  }

  /**
   * <pre>
   **
   * This interface contains file system master service endpoints for Alluxio workers.
   * </pre>
   */
  public static abstract class FileSystemMasterWorkerServiceImplBase implements alluxio.shaded.client.io.grpc.BindableService {

    /**
     * <pre>
     **
     * Periodic file system worker heartbeat. Returns the alluxio.shaded.client.com.and for persisting
     * the blocks of a file.
     * </pre>
     */
    public void fileSystemHeartbeat(alluxio.grpc.FileSystemHeartbeatPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.FileSystemHeartbeatPResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getFileSystemHeartbeatMethod(), responseObserver);
    }

    /**
     * <pre>
     * Returns the file information for a file or directory identified by the given file id.
     * </pre>
     */
    public void getFileInfo(alluxio.grpc.GetFileInfoPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetFileInfoPResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetFileInfoMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns the set of pinned file ids.
     * </pre>
     */
    public void getPinnedFileIds(alluxio.grpc.GetPinnedFileIdsPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetPinnedFileIdsPResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetPinnedFileIdsMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Returns the UFS information for the given mount point identified by its id.
     * </pre>
     */
    public void getUfsInfo(alluxio.grpc.GetUfsInfoPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetUfsInfoPResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetUfsInfoMethod(), responseObserver);
    }

    @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
      return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getFileSystemHeartbeatMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                alluxio.grpc.FileSystemHeartbeatPRequest,
                alluxio.grpc.FileSystemHeartbeatPResponse>(
                  this, METHODID_FILE_SYSTEM_HEARTBEAT)))
          .addMethod(
            getGetFileInfoMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                alluxio.grpc.GetFileInfoPRequest,
                alluxio.grpc.GetFileInfoPResponse>(
                  this, METHODID_GET_FILE_INFO)))
          .addMethod(
            getGetPinnedFileIdsMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                alluxio.grpc.GetPinnedFileIdsPRequest,
                alluxio.grpc.GetPinnedFileIdsPResponse>(
                  this, METHODID_GET_PINNED_FILE_IDS)))
          .addMethod(
            getGetUfsInfoMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                alluxio.grpc.GetUfsInfoPRequest,
                alluxio.grpc.GetUfsInfoPResponse>(
                  this, METHODID_GET_UFS_INFO)))
          .build();
    }
  }

  /**
   * <pre>
   **
   * This interface contains file system master service endpoints for Alluxio workers.
   * </pre>
   */
  public static final class FileSystemMasterWorkerServiceStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<FileSystemMasterWorkerServiceStub> {
    private FileSystemMasterWorkerServiceStub(alluxio.shaded.client.io.grpc.Channel channel) {
      super(channel);
    }

    private FileSystemMasterWorkerServiceStub(alluxio.shaded.client.io.grpc.Channel channel,
        alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected FileSystemMasterWorkerServiceStub build(alluxio.shaded.client.io.grpc.Channel channel,
        alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new FileSystemMasterWorkerServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Periodic file system worker heartbeat. Returns the alluxio.shaded.client.com.and for persisting
     * the blocks of a file.
     * </pre>
     */
    public void fileSystemHeartbeat(alluxio.grpc.FileSystemHeartbeatPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.FileSystemHeartbeatPResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getFileSystemHeartbeatMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Returns the file information for a file or directory identified by the given file id.
     * </pre>
     */
    public void getFileInfo(alluxio.grpc.GetFileInfoPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetFileInfoPResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetFileInfoMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns the set of pinned file ids.
     * </pre>
     */
    public void getPinnedFileIds(alluxio.grpc.GetPinnedFileIdsPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetPinnedFileIdsPResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetPinnedFileIdsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Returns the UFS information for the given mount point identified by its id.
     * </pre>
     */
    public void getUfsInfo(alluxio.grpc.GetUfsInfoPRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetUfsInfoPResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetUfsInfoMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   **
   * This interface contains file system master service endpoints for Alluxio workers.
   * </pre>
   */
  public static final class FileSystemMasterWorkerServiceBlockingStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<FileSystemMasterWorkerServiceBlockingStub> {
    private FileSystemMasterWorkerServiceBlockingStub(alluxio.shaded.client.io.grpc.Channel channel) {
      super(channel);
    }

    private FileSystemMasterWorkerServiceBlockingStub(alluxio.shaded.client.io.grpc.Channel channel,
        alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected FileSystemMasterWorkerServiceBlockingStub build(alluxio.shaded.client.io.grpc.Channel channel,
        alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new FileSystemMasterWorkerServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Periodic file system worker heartbeat. Returns the alluxio.shaded.client.com.and for persisting
     * the blocks of a file.
     * </pre>
     */
    public alluxio.grpc.FileSystemHeartbeatPResponse fileSystemHeartbeat(alluxio.grpc.FileSystemHeartbeatPRequest request) {
      return blockingUnaryCall(
          getChannel(), getFileSystemHeartbeatMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Returns the file information for a file or directory identified by the given file id.
     * </pre>
     */
    public alluxio.grpc.GetFileInfoPResponse getFileInfo(alluxio.grpc.GetFileInfoPRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetFileInfoMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns the set of pinned file ids.
     * </pre>
     */
    public alluxio.grpc.GetPinnedFileIdsPResponse getPinnedFileIds(alluxio.grpc.GetPinnedFileIdsPRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetPinnedFileIdsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Returns the UFS information for the given mount point identified by its id.
     * </pre>
     */
    public alluxio.grpc.GetUfsInfoPResponse getUfsInfo(alluxio.grpc.GetUfsInfoPRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetUfsInfoMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   **
   * This interface contains file system master service endpoints for Alluxio workers.
   * </pre>
   */
  public static final class FileSystemMasterWorkerServiceFutureStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<FileSystemMasterWorkerServiceFutureStub> {
    private FileSystemMasterWorkerServiceFutureStub(alluxio.shaded.client.io.grpc.Channel channel) {
      super(channel);
    }

    private FileSystemMasterWorkerServiceFutureStub(alluxio.shaded.client.io.grpc.Channel channel,
        alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected FileSystemMasterWorkerServiceFutureStub build(alluxio.shaded.client.io.grpc.Channel channel,
        alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new FileSystemMasterWorkerServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Periodic file system worker heartbeat. Returns the alluxio.shaded.client.com.and for persisting
     * the blocks of a file.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.FileSystemHeartbeatPResponse> fileSystemHeartbeat(
        alluxio.grpc.FileSystemHeartbeatPRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getFileSystemHeartbeatMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Returns the file information for a file or directory identified by the given file id.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetFileInfoPResponse> getFileInfo(
        alluxio.grpc.GetFileInfoPRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetFileInfoMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns the set of pinned file ids.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetPinnedFileIdsPResponse> getPinnedFileIds(
        alluxio.grpc.GetPinnedFileIdsPRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetPinnedFileIdsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Returns the UFS information for the given mount point identified by its id.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.grpc.GetUfsInfoPResponse> getUfsInfo(
        alluxio.grpc.GetUfsInfoPRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetUfsInfoMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_FILE_SYSTEM_HEARTBEAT = 0;
  private static final int METHODID_GET_FILE_INFO = 1;
  private static final int METHODID_GET_PINNED_FILE_IDS = 2;
  private static final int METHODID_GET_UFS_INFO = 3;

  private static final class MethodHandlers<Req, Resp> implements
      alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final FileSystemMasterWorkerServiceImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(FileSystemMasterWorkerServiceImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_FILE_SYSTEM_HEARTBEAT:
          serviceImpl.fileSystemHeartbeat((alluxio.grpc.FileSystemHeartbeatPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.FileSystemHeartbeatPResponse>) responseObserver);
          break;
        case METHODID_GET_FILE_INFO:
          serviceImpl.getFileInfo((alluxio.grpc.GetFileInfoPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetFileInfoPResponse>) responseObserver);
          break;
        case METHODID_GET_PINNED_FILE_IDS:
          serviceImpl.getPinnedFileIds((alluxio.grpc.GetPinnedFileIdsPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetPinnedFileIdsPResponse>) responseObserver);
          break;
        case METHODID_GET_UFS_INFO:
          serviceImpl.getUfsInfo((alluxio.grpc.GetUfsInfoPRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.grpc.GetUfsInfoPResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(
        alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class FileSystemMasterWorkerServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoFileDescriptorSupplier, alluxio.shaded.client.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    FileSystemMasterWorkerServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return alluxio.grpc.FileSystemMasterProto.getDescriptor();
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("FileSystemMasterWorkerService");
    }
  }

  private static final class FileSystemMasterWorkerServiceFileDescriptorSupplier
      extends FileSystemMasterWorkerServiceBaseDescriptorSupplier {
    FileSystemMasterWorkerServiceFileDescriptorSupplier() {}
  }

  private static final class FileSystemMasterWorkerServiceMethodDescriptorSupplier
      extends FileSystemMasterWorkerServiceBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    FileSystemMasterWorkerServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile alluxio.shaded.client.io.grpc.ServiceDescriptor serviceDescriptor;

  public static alluxio.shaded.client.io.grpc.ServiceDescriptor getServiceDescriptor() {
    alluxio.shaded.client.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (FileSystemMasterWorkerServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = alluxio.shaded.client.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new FileSystemMasterWorkerServiceFileDescriptorSupplier())
              .addMethod(getFileSystemHeartbeatMethod())
              .addMethod(getGetFileInfoMethod())
              .addMethod(getGetPinnedFileIdsMethod())
              .addMethod(getGetUfsInfoMethod())
              .build();
        }
      }
    }
    return result;
  }
}
