// Generated by the protocol buffer alluxio.shaded.client.com.iler.  DO NOT EDIT!
// source: google/api/documentation.proto

package alluxio.shaded.client.com.google.api;

/**
 * <pre>
 * `Documentation` provides the information for describing a service.
 * Example:
 * &lt;pre&gt;&lt;code&gt;documentation:
 *   summary: &gt;
 *     The Google Calendar API gives access
 *     to most calendar features.
 *   pages:
 *   - name: Overview
 *     content: &amp;#40;== include google/foo/overview.md ==&amp;#41;
 *   - name: Tutorial
 *     content: &amp;#40;== include google/foo/tutorial.md ==&amp;#41;
 *     subpages;
 *     - name: Java
 *       content: &amp;#40;== include google/foo/tutorial_java.md ==&amp;#41;
 *   rules:
 *   - selector: google.calendar.Calendar.Get
 *     description: &gt;
 *       ...
 *   - selector: google.calendar.Calendar.Put
 *     description: &gt;
 *       ...
 * &lt;/code&gt;&lt;/pre&gt;
 * Documentation is provided in markdown syntax. In addition to
 * standard markdown features, definition lists, tables and fenced
 * code blocks are supported. Section headers can be provided and are
 * interpreted relative to the section nesting of the context where
 * a documentation fragment is embedded.
 * Documentation from the IDL is merged with documentation defined
 * via the config at normalization time, where documentation provided
 * by config rules overrides IDL provided.
 * A number of constructs specific to the API platform are supported
 * in documentation text.
 * In order to reference a proto element, the following
 * notation can be used:
 * &lt;pre&gt;&lt;code&gt;&amp;#91;fully.qualified.proto.name]&amp;#91;]&lt;/code&gt;&lt;/pre&gt;
 * To override the display text used for the link, this can be used:
 * &lt;pre&gt;&lt;code&gt;&amp;#91;display text]&amp;#91;fully.qualified.proto.name]&lt;/code&gt;&lt;/pre&gt;
 * Text can be excluded from doc using the following notation:
 * &lt;pre&gt;&lt;code&gt;&amp;#40;-- internal alluxio.shaded.client.com.ent --&amp;#41;&lt;/code&gt;&lt;/pre&gt;
 * Comments can be made conditional using a visibility label. The below
 * text will be only rendered if the `BETA` label is available:
 * &lt;pre&gt;&lt;code&gt;&amp;#40;--BETA: alluxio.shaded.client.com.ent for BETA users --&amp;#41;&lt;/code&gt;&lt;/pre&gt;
 * A few directives are available in documentation. Note that
 * directives must appear on a single line to be properly
 * identified. The `include` directive includes a markdown file from
 * an external source:
 * &lt;pre&gt;&lt;code&gt;&amp;#40;== include path/to/file ==&amp;#41;&lt;/code&gt;&lt;/pre&gt;
 * The `resource_for` directive marks a message to be the resource of
 * a collection in REST view. If it is not specified, tools attempt
 * to infer the resource from the operations in a collection:
 * &lt;pre&gt;&lt;code&gt;&amp;#40;== resource_for v1.shelves.books ==&amp;#41;&lt;/code&gt;&lt;/pre&gt;
 * The directive `suppress_warning` does not directly affect documentation
 * and is documented together with service config validation.
 * </pre>
 *
 * Protobuf type {@code google.api.Documentation}
 */
public  final class Documentation extends
    alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.api.Documentation)
    DocumentationOrBuilder {
  // Use Documentation.newBuilder() to construct.
  private Documentation(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Documentation() {
    summary_ = "";
    pages_ = java.util.Collections.emptyList();
    rules_ = java.util.Collections.emptyList();
    documentationRootUrl_ = "";
    overview_ = "";
  }

  @java.lang.Override
  public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.getDefaultInstance();
  }
  private Documentation(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!input.skipField(tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            summary_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            overview_ = s;
            break;
          }
          case 26: {
            if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
              rules_ = new java.util.ArrayList<alluxio.shaded.client.com.google.api.DocumentationRule>();
              mutable_bitField0_ |= 0x00000004;
            }
            rules_.add(
                input.readMessage(alluxio.shaded.client.com.google.api.DocumentationRule.parser(), extensionRegistry));
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            documentationRootUrl_ = s;
            break;
          }
          case 42: {
            if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
              pages_ = new java.util.ArrayList<alluxio.shaded.client.com.google.api.Page>();
              mutable_bitField0_ |= 0x00000002;
            }
            pages_.add(
                input.readMessage(alluxio.shaded.client.com.google.api.Page.parser(), extensionRegistry));
            break;
          }
        }
      }
    } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.alluxio.shaded.client.io.IOException e) {
      throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
        rules_ = java.util.Collections.unmodifiableList(rules_);
      }
      if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
        pages_ = java.util.Collections.unmodifiableList(pages_);
      }
      makeExtensionsImmutable();
    }
  }
  public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return alluxio.shaded.client.com.google.api.DocumentationProto.internal_static_google_api_Documentation_descriptor;
  }

  protected alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return alluxio.shaded.client.com.google.api.DocumentationProto.internal_static_google_api_Documentation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            alluxio.shaded.client.com.google.api.Documentation.class, alluxio.shaded.client.com.google.api.Documentation.Builder.class);
  }

  private int bitField0_;
  public static final int SUMMARY_FIELD_NUMBER = 1;
  private volatile java.lang.Object summary_;
  /**
   * <pre>
   * A short summary of what the service does. Can only be provided by
   * plain text.
   * </pre>
   *
   * <code>string summary = 1;</code>
   */
  public java.lang.String getSummary() {
    java.lang.Object ref = summary_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      alluxio.shaded.client.com.google.protobuf.ByteString bs = 
          (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      summary_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * A short summary of what the service does. Can only be provided by
   * plain text.
   * </pre>
   *
   * <code>string summary = 1;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getSummaryBytes() {
    java.lang.Object ref = summary_;
    if (ref instanceof java.lang.String) {
      alluxio.shaded.client.com.google.protobuf.ByteString b = 
          alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      summary_ = b;
      return b;
    } else {
      return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGES_FIELD_NUMBER = 5;
  private java.util.List<alluxio.shaded.client.com.google.api.Page> pages_;
  /**
   * <pre>
   * The top level pages for the documentation set.
   * </pre>
   *
   * <code>repeated .google.api.Page pages = 5;</code>
   */
  public java.util.List<alluxio.shaded.client.com.google.api.Page> getPagesList() {
    return pages_;
  }
  /**
   * <pre>
   * The top level pages for the documentation set.
   * </pre>
   *
   * <code>repeated .google.api.Page pages = 5;</code>
   */
  public java.util.List<? extends alluxio.shaded.client.com.google.api.PageOrBuilder> 
      getPagesOrBuilderList() {
    return pages_;
  }
  /**
   * <pre>
   * The top level pages for the documentation set.
   * </pre>
   *
   * <code>repeated .google.api.Page pages = 5;</code>
   */
  public int getPagesCount() {
    return pages_.size();
  }
  /**
   * <pre>
   * The top level pages for the documentation set.
   * </pre>
   *
   * <code>repeated .google.api.Page pages = 5;</code>
   */
  public alluxio.shaded.client.com.google.api.Page getPages(int index) {
    return pages_.get(index);
  }
  /**
   * <pre>
   * The top level pages for the documentation set.
   * </pre>
   *
   * <code>repeated .google.api.Page pages = 5;</code>
   */
  public alluxio.shaded.client.com.google.api.PageOrBuilder getPagesOrBuilder(
      int index) {
    return pages_.get(index);
  }

  public static final int RULES_FIELD_NUMBER = 3;
  private java.util.List<alluxio.shaded.client.com.google.api.DocumentationRule> rules_;
  /**
   * <pre>
   * A list of documentation rules that apply to individual API elements.
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.DocumentationRule rules = 3;</code>
   */
  public java.util.List<alluxio.shaded.client.com.google.api.DocumentationRule> getRulesList() {
    return rules_;
  }
  /**
   * <pre>
   * A list of documentation rules that apply to individual API elements.
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.DocumentationRule rules = 3;</code>
   */
  public java.util.List<? extends alluxio.shaded.client.com.google.api.DocumentationRuleOrBuilder> 
      getRulesOrBuilderList() {
    return rules_;
  }
  /**
   * <pre>
   * A list of documentation rules that apply to individual API elements.
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.DocumentationRule rules = 3;</code>
   */
  public int getRulesCount() {
    return rules_.size();
  }
  /**
   * <pre>
   * A list of documentation rules that apply to individual API elements.
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.DocumentationRule rules = 3;</code>
   */
  public alluxio.shaded.client.com.google.api.DocumentationRule getRules(int index) {
    return rules_.get(index);
  }
  /**
   * <pre>
   * A list of documentation rules that apply to individual API elements.
   * **NOTE:** All service configuration rules follow "last one wins" order.
   * </pre>
   *
   * <code>repeated .google.api.DocumentationRule rules = 3;</code>
   */
  public alluxio.shaded.client.com.google.api.DocumentationRuleOrBuilder getRulesOrBuilder(
      int index) {
    return rules_.get(index);
  }

  public static final int DOCUMENTATION_ROOT_URL_FIELD_NUMBER = 4;
  private volatile java.lang.Object documentationRootUrl_;
  /**
   * <pre>
   * The URL to the root of documentation.
   * </pre>
   *
   * <code>string documentation_root_url = 4;</code>
   */
  public java.lang.String getDocumentationRootUrl() {
    java.lang.Object ref = documentationRootUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      alluxio.shaded.client.com.google.protobuf.ByteString bs = 
          (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      documentationRootUrl_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The URL to the root of documentation.
   * </pre>
   *
   * <code>string documentation_root_url = 4;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getDocumentationRootUrlBytes() {
    java.lang.Object ref = documentationRootUrl_;
    if (ref instanceof java.lang.String) {
      alluxio.shaded.client.com.google.protobuf.ByteString b = 
          alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      documentationRootUrl_ = b;
      return b;
    } else {
      return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OVERVIEW_FIELD_NUMBER = 2;
  private volatile java.lang.Object overview_;
  /**
   * <pre>
   * Declares a single overview page. For example:
   * &lt;pre&gt;&lt;code&gt;documentation:
   *   summary: ...
   *   overview: &amp;#40;== include overview.md ==&amp;#41;
   * &lt;/code&gt;&lt;/pre&gt;
   * This is a shortcut for the following declaration (using pages style):
   * &lt;pre&gt;&lt;code&gt;documentation:
   *   summary: ...
   *   pages:
   *   - name: Overview
   *     content: &amp;#40;== include overview.md ==&amp;#41;
   * &lt;/code&gt;&lt;/pre&gt;
   * Note: you cannot specify both `overview` field and `pages` field.
   * </pre>
   *
   * <code>string overview = 2;</code>
   */
  public java.lang.String getOverview() {
    java.lang.Object ref = overview_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      alluxio.shaded.client.com.google.protobuf.ByteString bs = 
          (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      overview_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Declares a single overview page. For example:
   * &lt;pre&gt;&lt;code&gt;documentation:
   *   summary: ...
   *   overview: &amp;#40;== include overview.md ==&amp;#41;
   * &lt;/code&gt;&lt;/pre&gt;
   * This is a shortcut for the following declaration (using pages style):
   * &lt;pre&gt;&lt;code&gt;documentation:
   *   summary: ...
   *   pages:
   *   - name: Overview
   *     content: &amp;#40;== include overview.md ==&amp;#41;
   * &lt;/code&gt;&lt;/pre&gt;
   * Note: you cannot specify both `overview` field and `pages` field.
   * </pre>
   *
   * <code>string overview = 2;</code>
   */
  public alluxio.shaded.client.com.google.protobuf.ByteString
      getOverviewBytes() {
    java.lang.Object ref = overview_;
    if (ref instanceof java.lang.String) {
      alluxio.shaded.client.com.google.protobuf.ByteString b = 
          alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      overview_ = b;
      return b;
    } else {
      return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                      throws java.alluxio.shaded.client.io.IOException {
    if (!getSummaryBytes().isEmpty()) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, summary_);
    }
    if (!getOverviewBytes().isEmpty()) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, overview_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      output.writeMessage(3, rules_.get(i));
    }
    if (!getDocumentationRootUrlBytes().isEmpty()) {
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.writeString(output, 4, documentationRootUrl_);
    }
    for (int i = 0; i < pages_.size(); i++) {
      output.writeMessage(5, pages_.get(i));
    }
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getSummaryBytes().isEmpty()) {
      size += alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alluxio.shaded.client.com.uteStringSize(1, summary_);
    }
    if (!getOverviewBytes().isEmpty()) {
      size += alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alluxio.shaded.client.com.uteStringSize(2, overview_);
    }
    for (int i = 0; i < rules_.size(); i++) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteMessageSize(3, rules_.get(i));
    }
    if (!getDocumentationRootUrlBytes().isEmpty()) {
      size += alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alluxio.shaded.client.com.uteStringSize(4, documentationRootUrl_);
    }
    for (int i = 0; i < pages_.size(); i++) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteMessageSize(5, pages_.get(i));
    }
    memoizedSize = size;
    return size;
  }

  private static final long serialVersionUID = 0L;
  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof alluxio.shaded.client.com.google.api.Documentation)) {
      return super.equals(obj);
    }
    alluxio.shaded.client.com.google.api.Documentation other = (alluxio.shaded.client.com.google.api.Documentation) obj;

    boolean result = true;
    result = result && getSummary()
        .equals(other.getSummary());
    result = result && getPagesList()
        .equals(other.getPagesList());
    result = result && getRulesList()
        .equals(other.getRulesList());
    result = result && getDocumentationRootUrl()
        .equals(other.getDocumentationRootUrl());
    result = result && getOverview()
        .equals(other.getOverview());
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SUMMARY_FIELD_NUMBER;
    hash = (53 * hash) + getSummary().hashCode();
    if (getPagesCount() > 0) {
      hash = (37 * hash) + PAGES_FIELD_NUMBER;
      hash = (53 * hash) + getPagesList().hashCode();
    }
    if (getRulesCount() > 0) {
      hash = (37 * hash) + RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesList().hashCode();
    }
    hash = (37 * hash) + DOCUMENTATION_ROOT_URL_FIELD_NUMBER;
    hash = (53 * hash) + getDocumentationRootUrl().hashCode();
    hash = (37 * hash) + OVERVIEW_FIELD_NUMBER;
    hash = (53 * hash) + getOverview().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static alluxio.shaded.client.com.google.api.Documentation parseFrom(
      java.nio.ByteBuffer data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static alluxio.shaded.client.com.google.api.Documentation parseFrom(
      java.nio.ByteBuffer data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static alluxio.shaded.client.com.google.api.Documentation parseFrom(
      alluxio.shaded.client.com.google.protobuf.ByteString data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static alluxio.shaded.client.com.google.api.Documentation parseFrom(
      alluxio.shaded.client.com.google.protobuf.ByteString data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static alluxio.shaded.client.com.google.api.Documentation parseFrom(byte[] data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static alluxio.shaded.client.com.google.api.Documentation parseFrom(
      byte[] data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static alluxio.shaded.client.com.google.api.Documentation parseFrom(java.alluxio.shaded.client.io.InputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static alluxio.shaded.client.com.google.api.Documentation parseFrom(
      java.alluxio.shaded.client.io.InputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static alluxio.shaded.client.com.google.api.Documentation parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static alluxio.shaded.client.com.google.api.Documentation parseDelimitedFrom(
      java.alluxio.shaded.client.io.InputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static alluxio.shaded.client.com.google.api.Documentation parseFrom(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static alluxio.shaded.client.com.google.api.Documentation parseFrom(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(alluxio.shaded.client.com.google.api.Documentation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * `Documentation` provides the information for describing a service.
   * Example:
   * &lt;pre&gt;&lt;code&gt;documentation:
   *   summary: &gt;
   *     The Google Calendar API gives access
   *     to most calendar features.
   *   pages:
   *   - name: Overview
   *     content: &amp;#40;== include google/foo/overview.md ==&amp;#41;
   *   - name: Tutorial
   *     content: &amp;#40;== include google/foo/tutorial.md ==&amp;#41;
   *     subpages;
   *     - name: Java
   *       content: &amp;#40;== include google/foo/tutorial_java.md ==&amp;#41;
   *   rules:
   *   - selector: google.calendar.Calendar.Get
   *     description: &gt;
   *       ...
   *   - selector: google.calendar.Calendar.Put
   *     description: &gt;
   *       ...
   * &lt;/code&gt;&lt;/pre&gt;
   * Documentation is provided in markdown syntax. In addition to
   * standard markdown features, definition lists, tables and fenced
   * code blocks are supported. Section headers can be provided and are
   * interpreted relative to the section nesting of the context where
   * a documentation fragment is embedded.
   * Documentation from the IDL is merged with documentation defined
   * via the config at normalization time, where documentation provided
   * by config rules overrides IDL provided.
   * A number of constructs specific to the API platform are supported
   * in documentation text.
   * In order to reference a proto element, the following
   * notation can be used:
   * &lt;pre&gt;&lt;code&gt;&amp;#91;fully.qualified.proto.name]&amp;#91;]&lt;/code&gt;&lt;/pre&gt;
   * To override the display text used for the link, this can be used:
   * &lt;pre&gt;&lt;code&gt;&amp;#91;display text]&amp;#91;fully.qualified.proto.name]&lt;/code&gt;&lt;/pre&gt;
   * Text can be excluded from doc using the following notation:
   * &lt;pre&gt;&lt;code&gt;&amp;#40;-- internal alluxio.shaded.client.com.ent --&amp;#41;&lt;/code&gt;&lt;/pre&gt;
   * Comments can be made conditional using a visibility label. The below
   * text will be only rendered if the `BETA` label is available:
   * &lt;pre&gt;&lt;code&gt;&amp;#40;--BETA: alluxio.shaded.client.com.ent for BETA users --&amp;#41;&lt;/code&gt;&lt;/pre&gt;
   * A few directives are available in documentation. Note that
   * directives must appear on a single line to be properly
   * identified. The `include` directive includes a markdown file from
   * an external source:
   * &lt;pre&gt;&lt;code&gt;&amp;#40;== include path/to/file ==&amp;#41;&lt;/code&gt;&lt;/pre&gt;
   * The `resource_for` directive marks a message to be the resource of
   * a collection in REST view. If it is not specified, tools attempt
   * to infer the resource from the operations in a collection:
   * &lt;pre&gt;&lt;code&gt;&amp;#40;== resource_for v1.shelves.books ==&amp;#41;&lt;/code&gt;&lt;/pre&gt;
   * The directive `suppress_warning` does not directly affect documentation
   * and is documented together with service config validation.
   * </pre>
   *
   * Protobuf type {@code google.api.Documentation}
   */
  public static final class Builder extends
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.api.Documentation)
      alluxio.shaded.client.com.google.api.DocumentationOrBuilder {
    public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return alluxio.shaded.client.com.google.api.DocumentationProto.internal_static_google_api_Documentation_descriptor;
    }

    protected alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return alluxio.shaded.client.com.google.api.DocumentationProto.internal_static_google_api_Documentation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              alluxio.shaded.client.com.google.api.Documentation.class, alluxio.shaded.client.com.google.api.Documentation.Builder.class);
    }

    // Construct using alluxio.shaded.client.com.google.api.Documentation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getPagesFieldBuilder();
        getRulesFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      summary_ = "";

      if (pagesBuilder_ == null) {
        pages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        pagesBuilder_.clear();
      }
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
      } else {
        rulesBuilder_.clear();
      }
      documentationRootUrl_ = "";

      overview_ = "";

      return this;
    }

    public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return alluxio.shaded.client.com.google.api.DocumentationProto.internal_static_google_api_Documentation_descriptor;
    }

    public alluxio.shaded.client.com.google.api.Documentation getDefaultInstanceForType() {
      return alluxio.shaded.client.com.google.api.Documentation.getDefaultInstance();
    }

    public alluxio.shaded.client.com.google.api.Documentation build() {
      alluxio.shaded.client.com.google.api.Documentation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public alluxio.shaded.client.com.google.api.Documentation buildPartial() {
      alluxio.shaded.client.com.google.api.Documentation result = new alluxio.shaded.client.com.google.api.Documentation(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.summary_ = summary_;
      if (pagesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          pages_ = java.util.Collections.unmodifiableList(pages_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.pages_ = pages_;
      } else {
        result.pages_ = pagesBuilder_.build();
      }
      if (rulesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) == 0x00000004)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.rules_ = rules_;
      } else {
        result.rules_ = rulesBuilder_.build();
      }
      result.documentationRootUrl_ = documentationRootUrl_;
      result.overview_ = overview_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
      if (other instanceof alluxio.shaded.client.com.google.api.Documentation) {
        return mergeFrom((alluxio.shaded.client.com.google.api.Documentation)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(alluxio.shaded.client.com.google.api.Documentation other) {
      if (other == alluxio.shaded.client.com.google.api.Documentation.getDefaultInstance()) return this;
      if (!other.getSummary().isEmpty()) {
        summary_ = other.summary_;
        onChanged();
      }
      if (pagesBuilder_ == null) {
        if (!other.pages_.isEmpty()) {
          if (pages_.isEmpty()) {
            pages_ = other.pages_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePagesIsMutable();
            pages_.addAll(other.pages_);
          }
          onChanged();
        }
      } else {
        if (!other.pages_.isEmpty()) {
          if (pagesBuilder_.isEmpty()) {
            pagesBuilder_.dispose();
            pagesBuilder_ = null;
            pages_ = other.pages_;
            bitField0_ = (bitField0_ & ~0x00000002);
            pagesBuilder_ = 
              alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getPagesFieldBuilder() : null;
          } else {
            pagesBuilder_.addAllMessages(other.pages_);
          }
        }
      }
      if (rulesBuilder_ == null) {
        if (!other.rules_.isEmpty()) {
          if (rules_.isEmpty()) {
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureRulesIsMutable();
            rules_.addAll(other.rules_);
          }
          onChanged();
        }
      } else {
        if (!other.rules_.isEmpty()) {
          if (rulesBuilder_.isEmpty()) {
            rulesBuilder_.dispose();
            rulesBuilder_ = null;
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000004);
            rulesBuilder_ = 
              alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getRulesFieldBuilder() : null;
          } else {
            rulesBuilder_.addAllMessages(other.rules_);
          }
        }
      }
      if (!other.getDocumentationRootUrl().isEmpty()) {
        documentationRootUrl_ = other.documentationRootUrl_;
        onChanged();
      }
      if (!other.getOverview().isEmpty()) {
        overview_ = other.overview_;
        onChanged();
      }
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      alluxio.shaded.client.com.google.api.Documentation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (alluxio.shaded.client.com.google.api.Documentation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object summary_ = "";
    /**
     * <pre>
     * A short summary of what the service does. Can only be provided by
     * plain text.
     * </pre>
     *
     * <code>string summary = 1;</code>
     */
    public java.lang.String getSummary() {
      java.lang.Object ref = summary_;
      if (!(ref instanceof java.lang.String)) {
        alluxio.shaded.client.com.google.protobuf.ByteString bs =
            (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        summary_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * A short summary of what the service does. Can only be provided by
     * plain text.
     * </pre>
     *
     * <code>string summary = 1;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getSummaryBytes() {
      java.lang.Object ref = summary_;
      if (ref instanceof String) {
        alluxio.shaded.client.com.google.protobuf.ByteString b = 
            alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        summary_ = b;
        return b;
      } else {
        return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * A short summary of what the service does. Can only be provided by
     * plain text.
     * </pre>
     *
     * <code>string summary = 1;</code>
     */
    public Builder setSummary(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      summary_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A short summary of what the service does. Can only be provided by
     * plain text.
     * </pre>
     *
     * <code>string summary = 1;</code>
     */
    public Builder clearSummary() {
      
      summary_ = getDefaultInstance().getSummary();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A short summary of what the service does. Can only be provided by
     * plain text.
     * </pre>
     *
     * <code>string summary = 1;</code>
     */
    public Builder setSummaryBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      summary_ = value;
      onChanged();
      return this;
    }

    private java.util.List<alluxio.shaded.client.com.google.api.Page> pages_ =
      java.util.Collections.emptyList();
    private void ensurePagesIsMutable() {
      if (!((bitField0_ & 0x00000002) == 0x00000002)) {
        pages_ = new java.util.ArrayList<alluxio.shaded.client.com.google.api.Page>(pages_);
        bitField0_ |= 0x00000002;
       }
    }

    private alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
        alluxio.shaded.client.com.google.api.Page, alluxio.shaded.client.com.google.api.Page.Builder, alluxio.shaded.client.com.google.api.PageOrBuilder> pagesBuilder_;

    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public java.util.List<alluxio.shaded.client.com.google.api.Page> getPagesList() {
      if (pagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pages_);
      } else {
        return pagesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public int getPagesCount() {
      if (pagesBuilder_ == null) {
        return pages_.size();
      } else {
        return pagesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public alluxio.shaded.client.com.google.api.Page getPages(int index) {
      if (pagesBuilder_ == null) {
        return pages_.get(index);
      } else {
        return pagesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder setPages(
        int index, alluxio.shaded.client.com.google.api.Page value) {
      if (pagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesIsMutable();
        pages_.set(index, value);
        onChanged();
      } else {
        pagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder setPages(
        int index, alluxio.shaded.client.com.google.api.Page.Builder builderForValue) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.set(index, builderForValue.build());
        onChanged();
      } else {
        pagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder addPages(alluxio.shaded.client.com.google.api.Page value) {
      if (pagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesIsMutable();
        pages_.add(value);
        onChanged();
      } else {
        pagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder addPages(
        int index, alluxio.shaded.client.com.google.api.Page value) {
      if (pagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePagesIsMutable();
        pages_.add(index, value);
        onChanged();
      } else {
        pagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder addPages(
        alluxio.shaded.client.com.google.api.Page.Builder builderForValue) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.add(builderForValue.build());
        onChanged();
      } else {
        pagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder addPages(
        int index, alluxio.shaded.client.com.google.api.Page.Builder builderForValue) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.add(index, builderForValue.build());
        onChanged();
      } else {
        pagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder addAllPages(
        java.lang.Iterable<? extends alluxio.shaded.client.com.google.api.Page> values) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        alluxio.shaded.client.com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, pages_);
        onChanged();
      } else {
        pagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder clearPages() {
      if (pagesBuilder_ == null) {
        pages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        pagesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public Builder removePages(int index) {
      if (pagesBuilder_ == null) {
        ensurePagesIsMutable();
        pages_.remove(index);
        onChanged();
      } else {
        pagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public alluxio.shaded.client.com.google.api.Page.Builder getPagesBuilder(
        int index) {
      return getPagesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public alluxio.shaded.client.com.google.api.PageOrBuilder getPagesOrBuilder(
        int index) {
      if (pagesBuilder_ == null) {
        return pages_.get(index);  } else {
        return pagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public java.util.List<? extends alluxio.shaded.client.com.google.api.PageOrBuilder> 
         getPagesOrBuilderList() {
      if (pagesBuilder_ != null) {
        return pagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pages_);
      }
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public alluxio.shaded.client.com.google.api.Page.Builder addPagesBuilder() {
      return getPagesFieldBuilder().addBuilder(
          alluxio.shaded.client.com.google.api.Page.getDefaultInstance());
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public alluxio.shaded.client.com.google.api.Page.Builder addPagesBuilder(
        int index) {
      return getPagesFieldBuilder().addBuilder(
          index, alluxio.shaded.client.com.google.api.Page.getDefaultInstance());
    }
    /**
     * <pre>
     * The top level pages for the documentation set.
     * </pre>
     *
     * <code>repeated .google.api.Page pages = 5;</code>
     */
    public java.util.List<alluxio.shaded.client.com.google.api.Page.Builder> 
         getPagesBuilderList() {
      return getPagesFieldBuilder().getBuilderList();
    }
    private alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
        alluxio.shaded.client.com.google.api.Page, alluxio.shaded.client.com.google.api.Page.Builder, alluxio.shaded.client.com.google.api.PageOrBuilder> 
        getPagesFieldBuilder() {
      if (pagesBuilder_ == null) {
        pagesBuilder_ = new alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
            alluxio.shaded.client.com.google.api.Page, alluxio.shaded.client.com.google.api.Page.Builder, alluxio.shaded.client.com.google.api.PageOrBuilder>(
                pages_,
                ((bitField0_ & 0x00000002) == 0x00000002),
                getParentForChildren(),
                isClean());
        pages_ = null;
      }
      return pagesBuilder_;
    }

    private java.util.List<alluxio.shaded.client.com.google.api.DocumentationRule> rules_ =
      java.util.Collections.emptyList();
    private void ensureRulesIsMutable() {
      if (!((bitField0_ & 0x00000004) == 0x00000004)) {
        rules_ = new java.util.ArrayList<alluxio.shaded.client.com.google.api.DocumentationRule>(rules_);
        bitField0_ |= 0x00000004;
       }
    }

    private alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
        alluxio.shaded.client.com.google.api.DocumentationRule, alluxio.shaded.client.com.google.api.DocumentationRule.Builder, alluxio.shaded.client.com.google.api.DocumentationRuleOrBuilder> rulesBuilder_;

    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public java.util.List<alluxio.shaded.client.com.google.api.DocumentationRule> getRulesList() {
      if (rulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rules_);
      } else {
        return rulesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public int getRulesCount() {
      if (rulesBuilder_ == null) {
        return rules_.size();
      } else {
        return rulesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public alluxio.shaded.client.com.google.api.DocumentationRule getRules(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder setRules(
        int index, alluxio.shaded.client.com.google.api.DocumentationRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.set(index, value);
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder setRules(
        int index, alluxio.shaded.client.com.google.api.DocumentationRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder addRules(alluxio.shaded.client.com.google.api.DocumentationRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder addRules(
        int index, alluxio.shaded.client.com.google.api.DocumentationRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(index, value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder addRules(
        alluxio.shaded.client.com.google.api.DocumentationRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder addRules(
        int index, alluxio.shaded.client.com.google.api.DocumentationRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder addAllRules(
        java.lang.Iterable<? extends alluxio.shaded.client.com.google.api.DocumentationRule> values) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        alluxio.shaded.client.com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, rules_);
        onChanged();
      } else {
        rulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder clearRules() {
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public Builder removeRules(int index) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.remove(index);
        onChanged();
      } else {
        rulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public alluxio.shaded.client.com.google.api.DocumentationRule.Builder getRulesBuilder(
        int index) {
      return getRulesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public alluxio.shaded.client.com.google.api.DocumentationRuleOrBuilder getRulesOrBuilder(
        int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);  } else {
        return rulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public java.util.List<? extends alluxio.shaded.client.com.google.api.DocumentationRuleOrBuilder> 
         getRulesOrBuilderList() {
      if (rulesBuilder_ != null) {
        return rulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rules_);
      }
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public alluxio.shaded.client.com.google.api.DocumentationRule.Builder addRulesBuilder() {
      return getRulesFieldBuilder().addBuilder(
          alluxio.shaded.client.com.google.api.DocumentationRule.getDefaultInstance());
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public alluxio.shaded.client.com.google.api.DocumentationRule.Builder addRulesBuilder(
        int index) {
      return getRulesFieldBuilder().addBuilder(
          index, alluxio.shaded.client.com.google.api.DocumentationRule.getDefaultInstance());
    }
    /**
     * <pre>
     * A list of documentation rules that apply to individual API elements.
     * **NOTE:** All service configuration rules follow "last one wins" order.
     * </pre>
     *
     * <code>repeated .google.api.DocumentationRule rules = 3;</code>
     */
    public java.util.List<alluxio.shaded.client.com.google.api.DocumentationRule.Builder> 
         getRulesBuilderList() {
      return getRulesFieldBuilder().getBuilderList();
    }
    private alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
        alluxio.shaded.client.com.google.api.DocumentationRule, alluxio.shaded.client.com.google.api.DocumentationRule.Builder, alluxio.shaded.client.com.google.api.DocumentationRuleOrBuilder> 
        getRulesFieldBuilder() {
      if (rulesBuilder_ == null) {
        rulesBuilder_ = new alluxio.shaded.client.com.google.protobuf.RepeatedFieldBuilderV3<
            alluxio.shaded.client.com.google.api.DocumentationRule, alluxio.shaded.client.com.google.api.DocumentationRule.Builder, alluxio.shaded.client.com.google.api.DocumentationRuleOrBuilder>(
                rules_,
                ((bitField0_ & 0x00000004) == 0x00000004),
                getParentForChildren(),
                isClean());
        rules_ = null;
      }
      return rulesBuilder_;
    }

    private java.lang.Object documentationRootUrl_ = "";
    /**
     * <pre>
     * The URL to the root of documentation.
     * </pre>
     *
     * <code>string documentation_root_url = 4;</code>
     */
    public java.lang.String getDocumentationRootUrl() {
      java.lang.Object ref = documentationRootUrl_;
      if (!(ref instanceof java.lang.String)) {
        alluxio.shaded.client.com.google.protobuf.ByteString bs =
            (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        documentationRootUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The URL to the root of documentation.
     * </pre>
     *
     * <code>string documentation_root_url = 4;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getDocumentationRootUrlBytes() {
      java.lang.Object ref = documentationRootUrl_;
      if (ref instanceof String) {
        alluxio.shaded.client.com.google.protobuf.ByteString b = 
            alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        documentationRootUrl_ = b;
        return b;
      } else {
        return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The URL to the root of documentation.
     * </pre>
     *
     * <code>string documentation_root_url = 4;</code>
     */
    public Builder setDocumentationRootUrl(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      documentationRootUrl_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The URL to the root of documentation.
     * </pre>
     *
     * <code>string documentation_root_url = 4;</code>
     */
    public Builder clearDocumentationRootUrl() {
      
      documentationRootUrl_ = getDefaultInstance().getDocumentationRootUrl();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The URL to the root of documentation.
     * </pre>
     *
     * <code>string documentation_root_url = 4;</code>
     */
    public Builder setDocumentationRootUrlBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      documentationRootUrl_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object overview_ = "";
    /**
     * <pre>
     * Declares a single overview page. For example:
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   overview: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * This is a shortcut for the following declaration (using pages style):
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   pages:
     *   - name: Overview
     *     content: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * Note: you cannot specify both `overview` field and `pages` field.
     * </pre>
     *
     * <code>string overview = 2;</code>
     */
    public java.lang.String getOverview() {
      java.lang.Object ref = overview_;
      if (!(ref instanceof java.lang.String)) {
        alluxio.shaded.client.com.google.protobuf.ByteString bs =
            (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        overview_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Declares a single overview page. For example:
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   overview: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * This is a shortcut for the following declaration (using pages style):
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   pages:
     *   - name: Overview
     *     content: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * Note: you cannot specify both `overview` field and `pages` field.
     * </pre>
     *
     * <code>string overview = 2;</code>
     */
    public alluxio.shaded.client.com.google.protobuf.ByteString
        getOverviewBytes() {
      java.lang.Object ref = overview_;
      if (ref instanceof String) {
        alluxio.shaded.client.com.google.protobuf.ByteString b = 
            alluxio.shaded.client.com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        overview_ = b;
        return b;
      } else {
        return (alluxio.shaded.client.com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Declares a single overview page. For example:
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   overview: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * This is a shortcut for the following declaration (using pages style):
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   pages:
     *   - name: Overview
     *     content: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * Note: you cannot specify both `overview` field and `pages` field.
     * </pre>
     *
     * <code>string overview = 2;</code>
     */
    public Builder setOverview(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      overview_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Declares a single overview page. For example:
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   overview: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * This is a shortcut for the following declaration (using pages style):
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   pages:
     *   - name: Overview
     *     content: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * Note: you cannot specify both `overview` field and `pages` field.
     * </pre>
     *
     * <code>string overview = 2;</code>
     */
    public Builder clearOverview() {
      
      overview_ = getDefaultInstance().getOverview();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Declares a single overview page. For example:
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   overview: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * This is a shortcut for the following declaration (using pages style):
     * &lt;pre&gt;&lt;code&gt;documentation:
     *   summary: ...
     *   pages:
     *   - name: Overview
     *     content: &amp;#40;== include overview.md ==&amp;#41;
     * &lt;/code&gt;&lt;/pre&gt;
     * Note: you cannot specify both `overview` field and `pages` field.
     * </pre>
     *
     * <code>string overview = 2;</code>
     */
    public Builder setOverviewBytes(
        alluxio.shaded.client.com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      overview_ = value;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }

    public final Builder mergeUnknownFields(
        final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }


    // @@protoc_insertion_point(builder_scope:google.api.Documentation)
  }

  // @@protoc_insertion_point(class_scope:google.api.Documentation)
  private static final alluxio.shaded.client.com.google.api.Documentation DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new alluxio.shaded.client.com.google.api.Documentation();
  }

  public static alluxio.shaded.client.com.google.api.Documentation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final alluxio.shaded.client.com.google.protobuf.Parser<Documentation>
      PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<Documentation>() {
    public Documentation parsePartialFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
        return new Documentation(input, extensionRegistry);
    }
  };

  public static alluxio.shaded.client.com.google.protobuf.Parser<Documentation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public alluxio.shaded.client.com.google.protobuf.Parser<Documentation> getParserForType() {
    return PARSER;
  }

  public alluxio.shaded.client.com.google.api.Documentation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

