/*
 * Copyright 2016 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.grpc.util;

import static alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.base.Preconditions.checkNotNull;

import alluxio.shaded.client.io.grpc.ExperimentalApi;
import alluxio.shaded.client.io.grpc.LoadBalancer;
import alluxio.shaded.client.io.grpc.LoadBalancerProvider;
import alluxio.shaded.client.io.grpc.LoadBalancerRegistry;

/**
 * A {@link LoadBalancer} that provides round-robin load balancing mechanism over the
 * addresses.
 *
 * @deprecated use {@link alluxio.shaded.client.io.grpc.LoadBalancerRegistry#getProvider} with "round-robin" policy.  This
 *             class will be deleted soon.
 */
@ExperimentalApi("https://github.alluxio.shaded.client.com.grpc/grpc-java/issues/1771")
@Deprecated
public final class RoundRobinLoadBalancerFactory extends LoadBalancer.Factory {

  private static RoundRobinLoadBalancerFactory instance;

  private final LoadBalancerProvider provider;

  private RoundRobinLoadBalancerFactory() {
    provider = checkNotNull(
        LoadBalancerRegistry.getDefaultRegistry().getProvider("round_robin"),
        "round_robin balancer not available");
  }

  /**
   * Gets the singleton instance of this factory.
   */
  public static synchronized RoundRobinLoadBalancerFactory getInstance() {
    if (instance == null) {
      instance = new RoundRobinLoadBalancerFactory();
    }
    return instance;
  }

  @Override
  public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
    return provider.newLoadBalancer(helper);
  }
}
