/*
 * Copyright 2017, OpenCensus Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.opencensus.trace.samplers;

import alluxio.shaded.client.io.opencensus.trace.Sampler;
import alluxio.shaded.client.io.opencensus.trace.Span;
import alluxio.shaded.client.io.opencensus.trace.SpanContext;
import alluxio.shaded.client.io.opencensus.trace.SpanId;
import alluxio.shaded.client.io.opencensus.trace.TraceId;
import java.util.List;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.Immutable;

/** Sampler that always makes a "yes" decision on {@link Span} sampling. */
@Immutable
final class AlwaysSampleSampler extends Sampler {

  AlwaysSampleSampler() {}

  // Returns always makes a "yes" decision on {@link Span} sampling.
  @Override
  public boolean shouldSample(
      @Nullable SpanContext parentContext,
      @Nullable Boolean hasRemoteParent,
      TraceId traceId,
      SpanId spanId,
      String name,
      List<Span> parentLinks) {
    return true;
  }

  @Override
  public String getDescription() {
    return toString();
  }

  @Override
  public String toString() {
    return "AlwaysSampleSampler";
  }
}
