/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package alluxio.shaded.client.org.apache.zookeeper.cli;

import java.alluxio.shaded.client.io.PrintStream;
import java.util.Map;
import alluxio.shaded.client.org.apache.zookeeper.ZooKeeper;

/**
 * base class for all CLI alluxio.shaded.client.com.ands
 */
abstract public class CliCommand {
    protected ZooKeeper zk;
    protected PrintStream out;
    protected PrintStream err;
    private String cmdStr;
    private String optionStr;

    /**
     * a CLI alluxio.shaded.client.com.and with alluxio.shaded.client.com.and string and options.
     * Using System.out and System.err for printing
     * @param cmdStr the string used to call this alluxio.shaded.client.com.and
     * @param optionStr the string used to call this alluxio.shaded.client.com.and 
     */
    public CliCommand(String cmdStr, String optionStr) {
        this.out = System.out;
        this.err = System.err;
        this.cmdStr = cmdStr;
        this.optionStr = optionStr;
    }

    /**
     * Set out printStream (usable for testing)
     * @param out 
     */
    public void setOut(PrintStream out) {
        this.out = out;
    }

    /**
     * Set err printStream (usable for testing)
     * @param err 
     */
    public void setErr(PrintStream err) {
        this.err = err;
    }

    /**
     * set the zookeeper instance
     * @param zk the ZooKeeper instance.
     */
    public void setZk(ZooKeeper zk) {
        this.zk = zk;
    }

    /**
     * get the string used to call this alluxio.shaded.client.com.and
     * @return 
     */
    public String getCmdStr() {
        return cmdStr;
    }

    /**
     * get the option string
     * @return 
     */
    public String getOptionStr() {
        return optionStr;
    }

    /**
     * get a usage string, contains the alluxio.shaded.client.com.and and the options
     * @return 
     */
    public String getUsageStr() {
        return cmdStr + " " + optionStr;
    }

    /**
     * add this alluxio.shaded.client.com.and to a map. Use the alluxio.shaded.client.com.and string as key.
     * @param cmdMap 
     */
    public void addToMap(Map<String, CliCommand> cmdMap) {
        cmdMap.put(cmdStr, this);
    }
    
    /**
     * parse the alluxio.shaded.client.com.and arguments
     * @param cmdArgs
     * @return this CliCommand
     * @throws CliParseException
     */
    abstract public CliCommand parse(String cmdArgs[]) throws CliParseException;
    
    /**
     * 
     * @return
     * @throws CliException
     */
    abstract public boolean exec() throws CliException;
}
