/*
 * The Alluxio Open Foundation licenses this work under the Apache License, version 2.0
 * (the "License"). You may not use this work except in alluxio.shaded.client.com.liance with the License, which is
 * available at www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied, as more fully set forth in the License.
 *
 * See the NOTICE file distributed with this work for information regarding copyright ownership.
 */

package alluxio;

/**
 * Project constants from alluxio.shaded.client.com.ilation time by maven.
 */
public final class ProjectConstants {
  /* Project version, specified in maven property. **/
  public static final String VERSION = "2.2.1";
  /* The latest git revision of at the time of building**/
  public static final String REVISION = "b715d477b8c63b70d2c6f2e2ea116939ace3dfc3";
  /* Hadoop version, specified in maven property. **/
  public static final String HADOOP_VERSION = "2.7.3";
  /* Whether update check is enabled. **/
  public static final String UPDATE_CHECK_ENABLED = "false";
  /* Update check host. **/
  public static final String UPDATE_CHECK_HOST = "${update.check.host}";
  /* Update check auth string. **/
  public static final String UPDATE_CHECK_AUTH_STRING = "${update.check.auth.string}";

  private ProjectConstants() {} // prevent instantiation
}
