// Generated by the protocol buffer alluxio.shaded.client.com.iler.  DO NOT EDIT!
// source: google/type/quaternion.proto

package alluxio.shaded.client.com.google.type;

/**
 * <pre>
 * A quaternion is defined as the quotient of two directed lines in a
 * three-dimensional space or equivalently as the quotient of two Euclidean
 * vectors (https://en.wikipedia.alluxio.shaded.client.org.wiki/Quaternion).
 * Quaternions are often used in calculations involving three-dimensional
 * rotations (https://en.wikipedia.alluxio.shaded.client.org.wiki/Quaternions_and_spatial_rotation),
 * as they provide greater mathematical robustness by avoiding the gimbal lock
 * problems that can be encountered when using Euler angles
 * (https://en.wikipedia.alluxio.shaded.client.org.wiki/Gimbal_lock).
 * Quaternions are generally represented in this form:
 *   w + xi + yj + zk
 * where x, y, z, and w are real numbers, and i, j, and k are three imaginary
 * numbers.
 * Our naming choice (x, y, z, w) alluxio.shaded.client.com.s from the desire to avoid confusion for
 * those interested in the geometric properties of the quaternion in the 3D
 * Cartesian space. Other texts often use alternative names or subscripts, such
 * as (a, b, c, d), (1, i, j, k), or (0, 1, 2, 3), which are perhaps better
 * suited for mathematical interpretations.
 * To avoid any confusion, as well as to maintain alluxio.shaded.client.com.atibility with a large
 * number of software libraries, the quaternions represented using the protocol
 * buffer below *must* follow the Hamilton convention, which defines ij = k
 * (i.e. a right-handed algebra), and therefore:
 *   i^2 = j^2 = k^2 = ijk = −1
 *   ij = −ji = k
 *   jk = −kj = i
 *   ki = −ik = j
 * Please DO NOT use this to represent quaternions that follow the JPL
 * convention, or any of the other quaternion flavors out there.
 * Definitions:
 *   - Quaternion norm (or magnitude): sqrt(x^2 + y^2 + z^2 + w^2).
 *   - Unit (or normalized) quaternion: a quaternion whose norm is 1.
 *   - Pure quaternion: a quaternion whose scalar alluxio.shaded.client.com.onent (w) is 0.
 *   - Rotation quaternion: a unit quaternion used to represent rotation.
 *   - Orientation quaternion: a unit quaternion used to represent orientation.
 * A quaternion can be normalized by dividing it by its norm. The resulting
 * quaternion maintains the same direction, but has a norm of 1, i.e. it moves
 * on the unit sphere. This is generally necessary for rotation and orientation
 * quaternions, to avoid rounding errors:
 * https://en.wikipedia.alluxio.shaded.client.org.wiki/Rotation_formalisms_in_three_dimensions
 * Note that (x, y, z, w) and (-x, -y, -z, -w) represent the same rotation, but
 * normalization would be even more useful, e.g. for alluxio.shaded.client.com.arison purposes, if it
 * would produce a unique representation. It is thus recommended that w be kept
 * positive, which can be achieved by changing all the signs when w is negative.
 * Next available tag: 5
 * </pre>
 *
 * Protobuf type {@code google.type.Quaternion}
 */
public  final class Quaternion extends
    alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.type.Quaternion)
    QuaternionOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Quaternion.newBuilder() to construct.
  private Quaternion(alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Quaternion() {
  }

  @Override
  public final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Quaternion(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new NullPointerException();
    }
    int mutable_bitField0_ = 0;
    alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        alluxio.shaded.client.com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 9: {

            x_ = input.readDouble();
            break;
          }
          case 17: {

            y_ = input.readDouble();
            break;
          }
          case 25: {

            z_ = input.readDouble();
            break;
          }
          case 33: {

            w_ = input.readDouble();
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.alluxio.shaded.client.io.IOException e) {
      throw new alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return alluxio.shaded.client.com.google.type.QuaternionProto.internal_static_google_type_Quaternion_descriptor;
  }

  @Override
  protected FieldAccessorTable
      internalGetFieldAccessorTable() {
    return alluxio.shaded.client.com.google.type.QuaternionProto.internal_static_google_type_Quaternion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            Quaternion.class, Builder.class);
  }

  public static final int X_FIELD_NUMBER = 1;
  private double x_;
  /**
   * <pre>
   * The x alluxio.shaded.client.com.onent.
   * </pre>
   *
   * <code>double x = 1;</code>
   */
  public double getX() {
    return x_;
  }

  public static final int Y_FIELD_NUMBER = 2;
  private double y_;
  /**
   * <pre>
   * The y alluxio.shaded.client.com.onent.
   * </pre>
   *
   * <code>double y = 2;</code>
   */
  public double getY() {
    return y_;
  }

  public static final int Z_FIELD_NUMBER = 3;
  private double z_;
  /**
   * <pre>
   * The z alluxio.shaded.client.com.onent.
   * </pre>
   *
   * <code>double z = 3;</code>
   */
  public double getZ() {
    return z_;
  }

  public static final int W_FIELD_NUMBER = 4;
  private double w_;
  /**
   * <pre>
   * The scalar alluxio.shaded.client.com.onent.
   * </pre>
   *
   * <code>double w = 4;</code>
   */
  public double getW() {
    return w_;
  }

  private byte memoizedIsInitialized = -1;
  @Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @Override
  public void writeTo(alluxio.shaded.client.com.google.protobuf.CodedOutputStream output)
                      throws java.alluxio.shaded.client.io.IOException {
    if (x_ != 0D) {
      output.writeDouble(1, x_);
    }
    if (y_ != 0D) {
      output.writeDouble(2, y_);
    }
    if (z_ != 0D) {
      output.writeDouble(3, z_);
    }
    if (w_ != 0D) {
      output.writeDouble(4, w_);
    }
    unknownFields.writeTo(output);
  }

  @Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (x_ != 0D) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteDoubleSize(1, x_);
    }
    if (y_ != 0D) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteDoubleSize(2, y_);
    }
    if (z_ != 0D) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteDoubleSize(3, z_);
    }
    if (w_ != 0D) {
      size += alluxio.shaded.client.com.google.protobuf.CodedOutputStream
        .alluxio.shaded.client.com.uteDoubleSize(4, w_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @Override
  public boolean equals(final Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof Quaternion)) {
      return super.equals(obj);
    }
    Quaternion other = (Quaternion) obj;

    if (Double.doubleToLongBits(getX())
        != Double.doubleToLongBits(
            other.getX())) return false;
    if (Double.doubleToLongBits(getY())
        != Double.doubleToLongBits(
            other.getY())) return false;
    if (Double.doubleToLongBits(getZ())
        != Double.doubleToLongBits(
            other.getZ())) return false;
    if (Double.doubleToLongBits(getW())
        != Double.doubleToLongBits(
            other.getW())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + X_FIELD_NUMBER;
    hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
        Double.doubleToLongBits(getX()));
    hash = (37 * hash) + Y_FIELD_NUMBER;
    hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
        Double.doubleToLongBits(getY()));
    hash = (37 * hash) + Z_FIELD_NUMBER;
    hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
        Double.doubleToLongBits(getZ()));
    hash = (37 * hash) + W_FIELD_NUMBER;
    hash = (53 * hash) + alluxio.shaded.client.com.google.protobuf.Internal.hashLong(
        Double.doubleToLongBits(getW()));
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static Quaternion parseFrom(
      java.nio.ByteBuffer data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static Quaternion parseFrom(
      java.nio.ByteBuffer data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static Quaternion parseFrom(
      alluxio.shaded.client.com.google.protobuf.ByteString data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static Quaternion parseFrom(
      alluxio.shaded.client.com.google.protobuf.ByteString data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static Quaternion parseFrom(byte[] data)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static Quaternion parseFrom(
      byte[] data,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static Quaternion parseFrom(java.alluxio.shaded.client.io.InputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static Quaternion parseFrom(
      java.alluxio.shaded.client.io.InputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static Quaternion parseDelimitedFrom(java.alluxio.shaded.client.io.InputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static Quaternion parseDelimitedFrom(
      java.alluxio.shaded.client.io.InputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static Quaternion parseFrom(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static Quaternion parseFrom(
      alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
      alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.alluxio.shaded.client.io.IOException {
    return alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(Quaternion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @Override
  protected Builder newBuilderForType(
      BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A quaternion is defined as the quotient of two directed lines in a
   * three-dimensional space or equivalently as the quotient of two Euclidean
   * vectors (https://en.wikipedia.alluxio.shaded.client.org.wiki/Quaternion).
   * Quaternions are often used in calculations involving three-dimensional
   * rotations (https://en.wikipedia.alluxio.shaded.client.org.wiki/Quaternions_and_spatial_rotation),
   * as they provide greater mathematical robustness by avoiding the gimbal lock
   * problems that can be encountered when using Euler angles
   * (https://en.wikipedia.alluxio.shaded.client.org.wiki/Gimbal_lock).
   * Quaternions are generally represented in this form:
   *   w + xi + yj + zk
   * where x, y, z, and w are real numbers, and i, j, and k are three imaginary
   * numbers.
   * Our naming choice (x, y, z, w) alluxio.shaded.client.com.s from the desire to avoid confusion for
   * those interested in the geometric properties of the quaternion in the 3D
   * Cartesian space. Other texts often use alternative names or subscripts, such
   * as (a, b, c, d), (1, i, j, k), or (0, 1, 2, 3), which are perhaps better
   * suited for mathematical interpretations.
   * To avoid any confusion, as well as to maintain alluxio.shaded.client.com.atibility with a large
   * number of software libraries, the quaternions represented using the protocol
   * buffer below *must* follow the Hamilton convention, which defines ij = k
   * (i.e. a right-handed algebra), and therefore:
   *   i^2 = j^2 = k^2 = ijk = −1
   *   ij = −ji = k
   *   jk = −kj = i
   *   ki = −ik = j
   * Please DO NOT use this to represent quaternions that follow the JPL
   * convention, or any of the other quaternion flavors out there.
   * Definitions:
   *   - Quaternion norm (or magnitude): sqrt(x^2 + y^2 + z^2 + w^2).
   *   - Unit (or normalized) quaternion: a quaternion whose norm is 1.
   *   - Pure quaternion: a quaternion whose scalar alluxio.shaded.client.com.onent (w) is 0.
   *   - Rotation quaternion: a unit quaternion used to represent rotation.
   *   - Orientation quaternion: a unit quaternion used to represent orientation.
   * A quaternion can be normalized by dividing it by its norm. The resulting
   * quaternion maintains the same direction, but has a norm of 1, i.e. it moves
   * on the unit sphere. This is generally necessary for rotation and orientation
   * quaternions, to avoid rounding errors:
   * https://en.wikipedia.alluxio.shaded.client.org.wiki/Rotation_formalisms_in_three_dimensions
   * Note that (x, y, z, w) and (-x, -y, -z, -w) represent the same rotation, but
   * normalization would be even more useful, e.g. for alluxio.shaded.client.com.arison purposes, if it
   * would produce a unique representation. It is thus recommended that w be kept
   * positive, which can be achieved by changing all the signs when w is negative.
   * Next available tag: 5
   * </pre>
   *
   * Protobuf type {@code google.type.Quaternion}
   */
  public static final class Builder extends
      alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.type.Quaternion)
      alluxio.shaded.client.com.google.type.QuaternionOrBuilder {
    public static final alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return alluxio.shaded.client.com.google.type.QuaternionProto.internal_static_google_type_Quaternion_descriptor;
    }

    @Override
    protected FieldAccessorTable
        internalGetFieldAccessorTable() {
      return alluxio.shaded.client.com.google.type.QuaternionProto.internal_static_google_type_Quaternion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              Quaternion.class, Builder.class);
    }

    // Construct using alluxio.shaded.client.com.google.type.Quaternion.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (alluxio.shaded.client.com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @Override
    public Builder clear() {
      super.clear();
      x_ = 0D;

      y_ = 0D;

      z_ = 0D;

      w_ = 0D;

      return this;
    }

    @Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return alluxio.shaded.client.com.google.type.QuaternionProto.internal_static_google_type_Quaternion_descriptor;
    }

    @Override
    public Quaternion getDefaultInstanceForType() {
      return Quaternion.getDefaultInstance();
    }

    @Override
    public Quaternion build() {
      Quaternion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @Override
    public Quaternion buildPartial() {
      Quaternion result = new Quaternion(this);
      result.x_ = x_;
      result.y_ = y_;
      result.z_ = z_;
      result.w_ = w_;
      onBuilt();
      return result;
    }

    @Override
    public Builder clone() {
      return super.clone();
    }
    @Override
    public Builder setField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return super.setField(field, value);
    }
    @Override
    public Builder clearField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @Override
    public Builder clearOneof(
        alluxio.shaded.client.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @Override
    public Builder setRepeatedField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @Override
    public Builder addRepeatedField(
        alluxio.shaded.client.com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return super.addRepeatedField(field, value);
    }
    @Override
    public Builder mergeFrom(alluxio.shaded.client.com.google.protobuf.Message other) {
      if (other instanceof Quaternion) {
        return mergeFrom((Quaternion)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(Quaternion other) {
      if (other == Quaternion.getDefaultInstance()) return this;
      if (other.getX() != 0D) {
        setX(other.getX());
      }
      if (other.getY() != 0D) {
        setY(other.getY());
      }
      if (other.getZ() != 0D) {
        setZ(other.getZ());
      }
      if (other.getW() != 0D) {
        setW(other.getW());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @Override
    public final boolean isInitialized() {
      return true;
    }

    @Override
    public Builder mergeFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.alluxio.shaded.client.io.IOException {
      Quaternion parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (Quaternion) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private double x_ ;
    /**
     * <pre>
     * The x alluxio.shaded.client.com.onent.
     * </pre>
     *
     * <code>double x = 1;</code>
     */
    public double getX() {
      return x_;
    }
    /**
     * <pre>
     * The x alluxio.shaded.client.com.onent.
     * </pre>
     *
     * <code>double x = 1;</code>
     */
    public Builder setX(double value) {
      
      x_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The x alluxio.shaded.client.com.onent.
     * </pre>
     *
     * <code>double x = 1;</code>
     */
    public Builder clearX() {
      
      x_ = 0D;
      onChanged();
      return this;
    }

    private double y_ ;
    /**
     * <pre>
     * The y alluxio.shaded.client.com.onent.
     * </pre>
     *
     * <code>double y = 2;</code>
     */
    public double getY() {
      return y_;
    }
    /**
     * <pre>
     * The y alluxio.shaded.client.com.onent.
     * </pre>
     *
     * <code>double y = 2;</code>
     */
    public Builder setY(double value) {
      
      y_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The y alluxio.shaded.client.com.onent.
     * </pre>
     *
     * <code>double y = 2;</code>
     */
    public Builder clearY() {
      
      y_ = 0D;
      onChanged();
      return this;
    }

    private double z_ ;
    /**
     * <pre>
     * The z alluxio.shaded.client.com.onent.
     * </pre>
     *
     * <code>double z = 3;</code>
     */
    public double getZ() {
      return z_;
    }
    /**
     * <pre>
     * The z alluxio.shaded.client.com.onent.
     * </pre>
     *
     * <code>double z = 3;</code>
     */
    public Builder setZ(double value) {
      
      z_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The z alluxio.shaded.client.com.onent.
     * </pre>
     *
     * <code>double z = 3;</code>
     */
    public Builder clearZ() {
      
      z_ = 0D;
      onChanged();
      return this;
    }

    private double w_ ;
    /**
     * <pre>
     * The scalar alluxio.shaded.client.com.onent.
     * </pre>
     *
     * <code>double w = 4;</code>
     */
    public double getW() {
      return w_;
    }
    /**
     * <pre>
     * The scalar alluxio.shaded.client.com.onent.
     * </pre>
     *
     * <code>double w = 4;</code>
     */
    public Builder setW(double value) {
      
      w_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The scalar alluxio.shaded.client.com.onent.
     * </pre>
     *
     * <code>double w = 4;</code>
     */
    public Builder clearW() {
      
      w_ = 0D;
      onChanged();
      return this;
    }
    @Override
    public final Builder setUnknownFields(
        final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @Override
    public final Builder mergeUnknownFields(
        final alluxio.shaded.client.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.type.Quaternion)
  }

  // @@protoc_insertion_point(class_scope:google.type.Quaternion)
  private static final Quaternion DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new Quaternion();
  }

  public static Quaternion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final alluxio.shaded.client.com.google.protobuf.Parser<Quaternion>
      PARSER = new alluxio.shaded.client.com.google.protobuf.AbstractParser<Quaternion>() {
    @Override
    public Quaternion parsePartialFrom(
        alluxio.shaded.client.com.google.protobuf.CodedInputStream input,
        alluxio.shaded.client.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws alluxio.shaded.client.com.google.protobuf.InvalidProtocolBufferException {
      return new Quaternion(input, extensionRegistry);
    }
  };

  public static alluxio.shaded.client.com.google.protobuf.Parser<Quaternion> parser() {
    return PARSER;
  }

  @Override
  public alluxio.shaded.client.com.google.protobuf.Parser<Quaternion> getParserForType() {
    return PARSER;
  }

  @Override
  public Quaternion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

