/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.PageId;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.OpenFilePOptions;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Meter;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.base.Suppliers;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.io.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

@NotThreadSafe
public class LocalCacheFileInStream
extends FileInStream {
    protected final long mPageSize;
    private final byte[] mSingleByte = new byte[1];
    private final Closer mCloser = Closer.create();
    private final CacheManager mCacheManager;
    private final FileSystem mExternalFs;
    private final AlluxioURI mPath;
    private final URIStatus mStatus;
    private final OpenFilePOptions mOpenOptions;
    private FileInStream mExternalFileInStream;
    private long mPosition = 0L;
    private boolean mClosed = false;
    private boolean mEOF = false;

    public LocalCacheFileInStream(AlluxioURI path, OpenFilePOptions options, FileSystem externalFs, CacheManager cacheManager) {
        this.mPageSize = externalFs.getConf().getBytes(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE);
        this.mPath = path;
        this.mOpenOptions = options;
        this.mExternalFs = externalFs;
        this.mCacheManager = cacheManager;
        this.mStatus = Suppliers.memoize(() -> {
            try {
                return externalFs.getStatus(this.mPath);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).get();
        Metrics.registerGauges();
    }

    public LocalCacheFileInStream(URIStatus status, OpenFilePOptions options, FileSystem externalFs, CacheManager cacheManager) {
        this.mPageSize = externalFs.getConf().getBytes(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE);
        this.mPath = new AlluxioURI(status.getPath());
        this.mOpenOptions = options;
        this.mExternalFs = externalFs;
        this.mCacheManager = cacheManager;
        this.mStatus = status;
        Metrics.registerGauges();
    }

    @Override
    public int read() throws IOException {
        int bytesRead = this.read(this.mSingleByte);
        if (bytesRead == -1) {
            return -1;
        }
        Preconditions.checkState(bytesRead == 1);
        return BufferUtils.byteToInt(this.mSingleByte[0]);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkArgument(len >= 0, "length should be non-negative");
        Preconditions.checkArgument(off >= 0, "offset should be non-negative");
        if (len == 0) {
            return 0;
        }
        if (this.mPosition >= this.mStatus.getLength()) {
            return -1;
        }
        int bytesRead = 0;
        long lengthToRead = Math.min((long)len, this.mStatus.getLength() - this.mPosition);
        while ((long)bytesRead < lengthToRead) {
            long currentPage = this.mPosition / this.mPageSize;
            int currentPageOffset = (int)(this.mPosition % this.mPageSize);
            int bytesLeftInPage = (int)Math.min(this.mPageSize - (long)currentPageOffset, lengthToRead - (long)bytesRead);
            PageId pageId = new PageId(this.mStatus.getFileIdentifier(), currentPage);
            ReadableByteChannel cachedData = this.mCacheManager.get(pageId, currentPageOffset);
            Throwable throwable = null;
            try {
                if (cachedData != null) {
                    ByteBuffer buf = ByteBuffer.wrap(b);
                    buf.position(off + bytesRead);
                    buf.limit(off + bytesRead + bytesLeftInPage);
                    while (buf.position() != buf.limit() && cachedData.read(buf) != -1) {
                    }
                    Preconditions.checkState(buf.position() == buf.limit());
                    bytesRead += bytesLeftInPage;
                    this.mPosition += (long)bytesLeftInPage;
                    Metrics.BYTES_READ_CACHE.mark(bytesLeftInPage);
                    continue;
                }
                byte[] page = this.readExternalPage(this.mPosition);
                if (page.length <= 0) continue;
                this.mCacheManager.put(pageId, page);
                System.arraycopy(page, currentPageOffset, b, off + bytesRead, bytesLeftInPage);
                bytesRead += bytesLeftInPage;
                this.mPosition += (long)bytesLeftInPage;
                Metrics.BYTES_REQUESTED_EXTERNAL.mark(bytesLeftInPage);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cachedData == null) continue;
                if (throwable != null) {
                    try {
                        cachedData.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                cachedData.close();
            }
        }
        Preconditions.checkState(bytesRead == len || bytesRead < len && this.remaining() == 0L, "Invalid number of bytes read - bytes to read = %d, actual bytes read = %d, bytes remains in file %d", (Object)len, (Object)bytesRead, (Object)this.remaining());
        return bytesRead;
    }

    @Override
    public long skip(long n) {
        this.checkIfClosed();
        if (n <= 0L) {
            return 0L;
        }
        long toSkip = Math.min(this.remaining(), n);
        this.mPosition += toSkip;
        return toSkip;
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }

    @Override
    public long remaining() {
        return this.mEOF ? 0L : this.mStatus.getLength() - this.mPosition;
    }

    @Override
    public int positionedRead(long pos, byte[] b, int off, int len) throws IOException {
        Preconditions.checkArgument(len >= 0, "length should be non-negative");
        Preconditions.checkArgument(off >= 0, "offset should be non-negative");
        Preconditions.checkArgument(pos >= 0L, "position should be non-negative");
        if (len == 0) {
            return 0;
        }
        if (pos < 0L || pos >= this.mStatus.getLength()) {
            return -1;
        }
        int bytesRead = 0;
        long currentPosition = pos;
        long lengthToRead = Math.min((long)len, this.mStatus.getLength() - pos);
        while ((long)bytesRead < lengthToRead) {
            long currentPage = currentPosition / this.mPageSize;
            int currentPageOffset = (int)(currentPosition % this.mPageSize);
            int bytesLeftInPage = (int)Math.min(this.mPageSize - (long)currentPageOffset, lengthToRead - (long)bytesRead);
            PageId pageId = new PageId(this.mStatus.getFileIdentifier(), currentPage);
            ReadableByteChannel cachedData = this.mCacheManager.get(pageId, currentPageOffset);
            Throwable throwable = null;
            try {
                if (cachedData != null) {
                    ByteBuffer buf = ByteBuffer.wrap(b);
                    buf.position(off + bytesRead);
                    buf.limit(off + bytesRead + bytesLeftInPage);
                    while (buf.position() != buf.limit() && cachedData.read(buf) != -1) {
                    }
                    Preconditions.checkState(buf.position() == buf.limit());
                    bytesRead += bytesLeftInPage;
                    currentPosition += (long)bytesLeftInPage;
                    Metrics.BYTES_READ_CACHE.mark(bytesLeftInPage);
                    continue;
                }
                byte[] page = this.readExternalPage(currentPosition);
                this.mCacheManager.put(pageId, page);
                System.arraycopy(page, currentPageOffset, b, off + bytesRead, bytesLeftInPage);
                bytesRead += bytesLeftInPage;
                currentPosition += (long)bytesLeftInPage;
                Metrics.BYTES_REQUESTED_EXTERNAL.mark(bytesLeftInPage);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cachedData == null) continue;
                if (throwable != null) {
                    try {
                        cachedData.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                cachedData.close();
            }
        }
        Preconditions.checkState(bytesRead == len || bytesRead < len && currentPosition == this.mStatus.getLength(), "Invalid number of bytes positionread - read from position = %d, bytes to read = %d, actual bytes read = %d, bytes remains in file %d", (Object)pos, (Object)len, (Object)bytesRead, (Object)(this.mStatus.getLength() - currentPosition));
        return bytesRead;
    }

    @Override
    public long getPos() {
        return this.mPosition;
    }

    @Override
    public void seek(long pos) {
        this.checkIfClosed();
        Preconditions.checkArgument(pos >= 0L, "Seek position is negative: %s", pos);
        Preconditions.checkArgument(pos <= this.mStatus.getLength(), "Seek position (%s) exceeds the length of the file (%s)", pos, this.mStatus.getLength());
        if (pos == this.mPosition) {
            return;
        }
        if (pos < this.mPosition) {
            this.mEOF = false;
        }
        this.mPosition = pos;
    }

    private void checkIfClosed() {
        Preconditions.checkState(!this.mClosed, "Cannot operate on a closed stream");
    }

    private FileInStream getExternalFileInStream(long pos) throws IOException {
        try {
            if (this.mExternalFileInStream == null) {
                this.mExternalFileInStream = this.mExternalFs.openFile(this.mStatus, this.mOpenOptions);
                this.mCloser.register(this.mExternalFileInStream);
            }
        }
        catch (AlluxioException e) {
            throw new IOException(e);
        }
        long pageStart = pos - pos % this.mPageSize;
        if (this.mExternalFileInStream.getPos() != pageStart) {
            this.mExternalFileInStream.seek(pageStart);
        }
        return this.mExternalFileInStream;
    }

    private synchronized byte[] readExternalPage(long pos) throws IOException {
        int totalBytesRead;
        int bytesRead;
        long pageStart = pos - pos % this.mPageSize;
        FileInStream stream = this.getExternalFileInStream(pageStart);
        int pageSize = (int)Math.min(this.mPageSize, this.mStatus.getLength() - pageStart);
        byte[] page = new byte[pageSize];
        for (totalBytesRead = 0; totalBytesRead < pageSize && (bytesRead = stream.read(page, totalBytesRead, pageSize - totalBytesRead)) > 0; totalBytesRead += bytesRead) {
        }
        Metrics.BYTES_READ_EXTERNAL.mark(totalBytesRead);
        if (totalBytesRead != pageSize) {
            throw new IOException("Failed to read complete page from external storage. Bytes read: " + totalBytesRead + " Page size: " + pageSize);
        }
        return page;
    }

    private static final class Metrics {
        private static final Meter BYTES_READ_CACHE = MetricsSystem.meter(MetricKey.CLIENT_CACHE_BYTES_READ_CACHE.getName());
        private static final Meter BYTES_READ_EXTERNAL = MetricsSystem.meter(MetricKey.CLIENT_CACHE_BYTES_READ_EXTERNAL.getName());
        private static final Meter BYTES_REQUESTED_EXTERNAL = MetricsSystem.meter(MetricKey.CLIENT_CACHE_BYTES_REQUESTED_EXTERNAL.getName());

        private Metrics() {
        }

        private static void registerGauges() {
            MetricsSystem.registerGaugeIfAbsent(MetricsSystem.getMetricName(MetricKey.CLIENT_CACHE_HIT_RATE.getName()), () -> {
                long cacheMisses;
                long cacheHits = BYTES_READ_CACHE.getCount();
                long total = cacheHits + (cacheMisses = BYTES_REQUESTED_EXTERNAL.getCount());
                if (total > 0L) {
                    return (double)cacheHits / (1.0 * (double)total);
                }
                return 0;
            });
        }
    }
}

