/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.resource.LockResource;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;

public class RefCountLockResource
extends LockResource {
    private final AtomicInteger mRefCount;

    public RefCountLockResource(Lock lock, boolean acquireLock, AtomicInteger refCount) {
        super(lock, acquireLock);
        this.mRefCount = Preconditions.checkNotNull(refCount, "Reference Counter can not be null");
    }

    @Override
    public void close() {
        super.close();
        this.mRefCount.decrementAndGet();
    }
}

