/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in alluxio.shaded.client.com.liance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.io.output;

import java.alluxio.shaded.client.io.OutputStream;

/**
 * Proxy stream that prevents the underlying output stream from being closed.
 * <p>
 * This class is typically used in cases where an output stream needs to be
 * passed to a alluxio.shaded.client.com.onent that wants to explicitly close the stream even if
 * other alluxio.shaded.client.com.onents would still use the stream for output.
 *
 * @version $Id: CloseShieldOutputStream.java 1304052 2012-03-22 20:55:29Z ggregory $
 * @since 1.4
 */
public class CloseShieldOutputStream extends ProxyOutputStream {

    /**
     * Creates a proxy that shields the given output stream from being
     * closed.
     *
     * @param out underlying output stream
     */
    public CloseShieldOutputStream(OutputStream out) {
        super(out);
    }

    /**
     * Replaces the underlying output stream with a {@link ClosedOutputStream}
     * sentinel. The original output stream will remain open, but this proxy
     * will appear closed.
     */
    @Override
    public void close() {
        out = new ClosedOutputStream();
    }

}
