/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcNetworkGroup;
import alluxio.grpc.GrpcServerAddress;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.org.apache.commons.lang.builder.HashCodeBuilder;
import alluxio.util.network.NetworkAddressUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.UUID;

public class GrpcChannelKey {
    @IdentityField
    GrpcNetworkGroup mNetworkGroup = GrpcNetworkGroup.RPC;
    @IdentityField
    private GrpcServerAddress mServerAddress;
    private final UUID mChannelId = UUID.randomUUID();
    private final String mLocalHostName;
    private String mClientType;

    private GrpcChannelKey(AlluxioConfiguration conf) {
        String localHostName;
        try {
            localHostName = NetworkAddressUtils.getLocalHostName((int)conf.getMs(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS));
        }
        catch (Exception e) {
            localHostName = "<UNKNOWN>";
        }
        this.mLocalHostName = localHostName;
    }

    public static GrpcChannelKey create(AlluxioConfiguration conf) {
        return new GrpcChannelKey(conf);
    }

    public UUID getChannelId() {
        return this.mChannelId;
    }

    public GrpcServerAddress getServerAddress() {
        return this.mServerAddress;
    }

    public GrpcChannelKey setServerAddress(GrpcServerAddress address) {
        this.mServerAddress = address;
        return this;
    }

    public GrpcChannelKey setNetworkGroup(GrpcNetworkGroup group) {
        this.mNetworkGroup = group;
        return this;
    }

    public GrpcNetworkGroup getNetworkGroup() {
        return this.mNetworkGroup;
    }

    public GrpcChannelKey setClientType(String clientType) {
        this.mClientType = clientType;
        return this;
    }

    public int hashCode() {
        HashCodeBuilder hashCodebuilder = new HashCodeBuilder();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(IdentityField.class)) continue;
            try {
                hashCodebuilder.append(field.get(this));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("Failed to calculate hashcode for channel-key: %s", this), e);
            }
        }
        return hashCodebuilder.toHashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof GrpcChannelKey) {
            GrpcChannelKey otherKey = (GrpcChannelKey)other;
            boolean areEqual = true;
            for (Field field : this.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(IdentityField.class)) continue;
                try {
                    areEqual &= field.get(this).equals(field.get(otherKey));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(String.format("Failed to calculate equality between channel-keys source: %s | destination: %s", this, otherKey), e);
                }
            }
            return areEqual;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("ClientType", this.mClientType).add("ServerAddress", this.mServerAddress).add("ChannelId", this.mChannelId).omitNullValues().toString();
    }

    public String toStringShort() {
        return MoreObjects.toStringHelper(this).add("ClientType", this.mClientType).add("ClientHostname", this.mLocalHostName).add("ServerAddress", this.mServerAddress).add("ChannelId", this.mChannelId).omitNullValues().toString();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface IdentityField {
    }
}

