/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.AlluxioURI;
import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.LocalCacheFileInStream;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.Source;
import alluxio.grpc.OpenFilePOptions;
import alluxio.hadoop.AlluxioHdfsFileSystem;
import alluxio.hadoop.HadoopConfigurationUtils;
import alluxio.hadoop.HadoopUtils;
import alluxio.hadoop.HdfsFileInputStream;
import alluxio.metrics.MetricsConfig;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.util.ConfigurationUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCacheFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCacheFileSystem.class);
    private static final Set<String> SUPPORTED_FS = new HashSet<String>(){
        {
            this.add("alluxio");
            this.add("ws");
        }
    };
    private final FileSystem mExternalFileSystem;
    private final AlluxioHdfsFileSystem mExternalFileSystemWrapper;
    private CacheManager mCacheManager;
    private Configuration mHadoopConf;
    private AlluxioConfiguration mAlluxioConf;

    public LocalCacheFileSystem(FileSystem fileSystem) {
        this.mExternalFileSystem = Preconditions.checkNotNull(fileSystem, "filesystem");
        this.mExternalFileSystemWrapper = new AlluxioHdfsFileSystem(this.mExternalFileSystem);
    }

    public synchronized void initialize(URI uri, Configuration conf) throws IOException {
        if (!SUPPORTED_FS.contains(uri.getScheme())) {
            throw new UnsupportedOperationException(uri.getScheme() + " is not supported as the external filesystem.");
        }
        super.initialize(uri, conf);
        this.mHadoopConf = conf;
        this.setConf(conf);
        Map<String, Object> hadoopConfProperties = HadoopConfigurationUtils.getConfigurationFromHadoop(conf);
        LOG.info("Creating Alluxio configuration from Hadoop configuration {}", hadoopConfProperties);
        AlluxioProperties alluxioProps = ConfigurationUtils.defaults();
        alluxioProps.merge(hadoopConfProperties, Source.RUNTIME);
        this.mAlluxioConf = new InstancedConfiguration(alluxioProps);
        Properties metricsProperties = new Properties();
        for (Map.Entry entry : conf) {
            metricsProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        MetricsSystem.startSinksFromConfig(new MetricsConfig(metricsProperties));
        this.mCacheManager = CacheManager.Factory.get(this.mAlluxioConf);
    }

    public void close() throws IOException {
        super.close();
        this.mExternalFileSystem.close();
    }

    public String getScheme() {
        return this.mExternalFileSystem.getScheme();
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        if (this.mCacheManager == null) {
            return this.mExternalFileSystem.open(path, bufferSize);
        }
        return new FSDataInputStream((InputStream)new HdfsFileInputStream(new LocalCacheFileInStream(new AlluxioURI(path.toString()), OpenFilePOptions.getDefaultInstance(), (alluxio.client.file.FileSystem)this.mExternalFileSystemWrapper, this.mCacheManager), this.statistics));
    }

    public FSDataInputStream open(URIStatus status, int bufferSize) throws IOException {
        if (this.mCacheManager == null) {
            return this.mExternalFileSystem.open(HadoopUtils.toPath(new AlluxioURI(status.getPath())), bufferSize);
        }
        return new FSDataInputStream((InputStream)new HdfsFileInputStream(new LocalCacheFileInStream(status, OpenFilePOptions.getDefaultInstance(), (alluxio.client.file.FileSystem)this.mExternalFileSystemWrapper, this.mCacheManager), this.statistics));
    }

    public URI getUri() {
        return this.mExternalFileSystem.getUri();
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.mExternalFileSystem.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.mExternalFileSystem.append(f, bufferSize, progress);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.mExternalFileSystem.rename(src, dst);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.mExternalFileSystem.delete(f, recursive);
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        return this.mExternalFileSystem.listStatus(f);
    }

    public void setWorkingDirectory(Path new_dir) {
        this.mExternalFileSystem.setWorkingDirectory(new_dir);
    }

    public Path getWorkingDirectory() {
        return this.mExternalFileSystem.getWorkingDirectory();
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.mExternalFileSystem.mkdirs(f, permission);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return this.mExternalFileSystem.getFileStatus(f);
    }
}

